/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.crafttweaker.actions;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.natives.block.ExpandBlock;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import moze_intel.projecte.api.world_transmutation.IWorldTransmutation;
import moze_intel.projecte.api.world_transmutation.SimpleWorldTransmutation;
import moze_intel.projecte.api.world_transmutation.WorldTransmutation;
import moze_intel.projecte.world_transmutation.WorldTransmutationManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class WorldTransmuteAction
implements IUndoableAction {
    protected final IWorldTransmutation transmutation;
    private final boolean add;

    public WorldTransmuteAction(IWorldTransmutation transmutation, boolean add) {
        this.transmutation = transmutation;
        this.add = add;
    }

    public String systemName() {
        return "ProjectE";
    }

    public void apply() {
        this.apply(this.add);
    }

    public void undo() {
        this.apply(!this.add);
    }

    private void apply(boolean add) {
        if (add) {
            WorldTransmutationManager.INSTANCE.register(this.transmutation);
        } else {
            WorldTransmutationManager.INSTANCE.removeWorldTransmutation(this.transmutation);
        }
    }

    private String describeTransmutation() {
        IWorldTransmutation iWorldTransmutation = this.transmutation;
        Objects.requireNonNull(iWorldTransmutation);
        IWorldTransmutation iWorldTransmutation2 = iWorldTransmutation;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SimpleWorldTransmutation.class, WorldTransmutation.class}, (Object)iWorldTransmutation2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                SimpleWorldTransmutation simple = (SimpleWorldTransmutation)iWorldTransmutation2;
                String representation = ExpandBlock.getCommandString((Block)((Block)simple.origin().value())) + " with output: " + ExpandBlock.getCommandString((Block)((Block)simple.result().value()));
                if (simple.hasAlternate()) {
                    representation = representation + " and secondary output: " + ExpandBlock.getCommandString((Block)((Block)simple.altResult().value()));
                }
                yield representation;
            }
            case 1 -> {
                WorldTransmutation worldTransmutation = (WorldTransmutation)iWorldTransmutation2;
                String representation = ExpandBlockState.getCommandString((BlockState)worldTransmutation.originState()) + " with output: " + ExpandBlockState.getCommandString((BlockState)worldTransmutation.result());
                if (worldTransmutation.hasAlternate()) {
                    representation = representation + " and secondary output: " + ExpandBlockState.getCommandString((BlockState)worldTransmutation.altResult());
                }
                yield representation;
            }
        };
    }

    public String describe() {
        return (this.add ? "Adding" : "Removing") + " world transmutation recipe for: " + this.describeTransmutation();
    }

    public String describeUndo() {
        return "Undoing " + (this.add ? "addition" : "removal") + " of world transmutation recipe for: " + this.describeTransmutation();
    }

    public static class RemoveAll
    implements IUndoableAction {
        public void apply() {
            WorldTransmutationManager.INSTANCE.clearTransmutations();
        }

        public String describe() {
            return "Removing all world transmutation recipes";
        }

        public void undo() {
            WorldTransmutationManager.INSTANCE.resetWorldTransmutations();
        }

        public String describeUndo() {
            return "Restored world transmutation recipes to default";
        }

        public String systemName() {
            return "ProjectE";
        }
    }
}

