/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.Predicate;
import moze_intel.projecte.PECore;
import moze_intel.projecte.PEPermissions;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.capabilities.IKnowledgeProvider;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.utils.text.ILangEntry;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class KnowledgeCMD {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext context) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"knowledge").requires((Predicate)PEPermissions.COMMAND_KNOWLEDGE)).then(KnowledgeCMD.subCommandClear())).then(((LiteralArgumentBuilder)Commands.literal((String)"learn").requires((Predicate)PEPermissions.COMMAND_KNOWLEDGE_LEARN)).then(KnowledgeCMD.executeWithParameters(ActionType.LEARN, context)))).then(((LiteralArgumentBuilder)Commands.literal((String)"unlearn").requires((Predicate)PEPermissions.COMMAND_KNOWLEDGE_UNLEARN)).then(KnowledgeCMD.executeWithParameters(ActionType.UNLEARN, context)))).then(((LiteralArgumentBuilder)Commands.literal((String)"test").requires((Predicate)PEPermissions.COMMAND_KNOWLEDGE_TEST)).then(KnowledgeCMD.executeWithParameters(ActionType.TEST, context)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> executeWithParameters(ActionType actionType, CommandBuildContext context) {
        return Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(ctx -> KnowledgeCMD.handle((CommandContext<CommandSourceStack>)ctx, actionType)));
    }

    @Nullable
    private static IKnowledgeProvider getProvider(ServerPlayer player) {
        return (IKnowledgeProvider)player.getCapability(PECapabilities.KNOWLEDGE_CAPABILITY);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> subCommandClear() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"clear").requires((Predicate)PEPermissions.COMMAND_KNOWLEDGE_CLEAR)).then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            int successCount = 0;
            for (ServerPlayer player : EntityArgument.getPlayers((CommandContext)ctx, (String)"targets")) {
                IKnowledgeProvider provider = KnowledgeCMD.getProvider(player);
                if (provider == null) {
                    source.sendFailure((Component)PELang.COMMAND_PROVIDER_FAIL.translate(player.getDisplayName()));
                    continue;
                }
                if (provider.getKnowledge().isEmpty()) {
                    source.sendFailure((Component)PELang.COMMAND_KNOWLEDGE_CLEAR_FAIL.translate(player.getDisplayName()));
                    continue;
                }
                provider.clearKnowledge();
                PECore.packetHandler().clearKnowledge(player);
                source.sendSuccess(() -> PELang.COMMAND_KNOWLEDGE_CLEAR_SUCCESS.translateColored(ChatFormatting.GREEN, player.getDisplayName()), true);
                ++successCount;
            }
            return successCount;
        }));
    }

    private static int handle(CommandContext<CommandSourceStack> ctx, ActionType action) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        IKnowledgeProvider provider = KnowledgeCMD.getProvider(player);
        if (provider == null) {
            source.sendFailure((Component)PELang.COMMAND_PROVIDER_FAIL.translate(player.getDisplayName()));
            return 0;
        }
        ItemStack item = ItemArgument.getItem(ctx, (String)"item").createItemStack(1, false);
        Component displayName = item.getDisplayName();
        if (item.isEmpty()) {
            source.sendFailure((Component)PELang.COMMAND_KNOWLEDGE_INVALID.translate(displayName));
            return 0;
        }
        ItemInfo itemInfo = IEMCProxy.INSTANCE.getPersistentInfo(ItemInfo.fromStack(item));
        if (!IEMCProxy.INSTANCE.hasValue(itemInfo)) {
            source.sendFailure((Component)PELang.COMMAND_KNOWLEDGE_INVALID.translate(displayName));
            return 0;
        }
        switch (action.ordinal()) {
            case 0: {
                if (provider.hasKnowledge(itemInfo)) {
                    return KnowledgeCMD.failure(source, PELang.COMMAND_KNOWLEDGE_LEARN_FAIL, (Player)player, displayName);
                }
                provider.addKnowledge(itemInfo);
                KnowledgeCMD.success(source, PELang.COMMAND_KNOWLEDGE_LEARN_SUCCESS, (Player)player, displayName);
                break;
            }
            case 1: {
                if (!provider.hasKnowledge(itemInfo)) {
                    return KnowledgeCMD.failure(source, PELang.COMMAND_KNOWLEDGE_UNLEARN_FAIL, (Player)player, displayName);
                }
                provider.removeKnowledge(itemInfo);
                KnowledgeCMD.success(source, PELang.COMMAND_KNOWLEDGE_UNLEARN_SUCCESS, (Player)player, displayName);
                break;
            }
            case 2: {
                if (provider.hasKnowledge(itemInfo)) {
                    KnowledgeCMD.success(source, PELang.COMMAND_KNOWLEDGE_TEST_SUCCESS, (Player)player, displayName);
                    return 1;
                }
                return KnowledgeCMD.failure(source, PELang.COMMAND_KNOWLEDGE_TEST_FAIL, (Player)player, displayName);
            }
        }
        provider.syncKnowledgeChange(player, itemInfo, action == ActionType.LEARN);
        return 1;
    }

    private static void success(CommandSourceStack source, ILangEntry successMessage, Player player, Component item) {
        source.sendSuccess(() -> successMessage.translateColored(ChatFormatting.GREEN, player.getDisplayName(), item), true);
    }

    private static int failure(CommandSourceStack source, ILangEntry failureMessage, Player player, Component item) {
        source.sendFailure((Component)failureMessage.translate(player.getDisplayName(), item));
        return 0;
    }

    private static enum ActionType {
        LEARN,
        UNLEARN,
        TEST;

    }
}

