/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.cad;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.piece.PieceCraftingTrick;
import vazkii.psi.common.item.base.ModDataComponents;

public interface ICAD {
    public static void setComponent(ItemStack stack, ItemStack componentStack) {
        Item item;
        @Nullable ArrayList<Item> items = (ArrayList<Item>)stack.getOrDefault(ModDataComponents.COMPONENTS, new ArrayList<Item>(Collections.nCopies(EnumCADComponent.values().length, Items.AIR)));
        if (!componentStack.isEmpty() && (item = componentStack.getItem()) instanceof ICADComponent) {
            ICADComponent component = (ICADComponent)item;
            if (!(items instanceof ArrayList)) {
                items = new ArrayList<Item>(items);
            }
            EnumCADComponent componentType = component.getComponentType(componentStack);
            items.set(componentType.ordinal(), componentStack.getItem());
            stack.set(ModDataComponents.COMPONENTS, items);
        }
    }

    public static void copyComponents(ItemStack from, ItemStack to) {
        if (!(from.getItem() instanceof ICAD) || !(to.getItem() instanceof ICAD)) {
            return;
        }
        List fromComponents = (List)from.get(ModDataComponents.COMPONENTS);
        to.set(ModDataComponents.COMPONENTS, new ArrayList(Objects.requireNonNullElseGet(fromComponents, () -> Collections.nCopies(EnumCADComponent.values().length, Items.AIR))));
    }

    default public void setCADComponent(ItemStack stack, ItemStack component) {
        ICAD.setComponent(stack, component);
    }

    public ItemStack getComponentInSlot(ItemStack var1, EnumCADComponent var2);

    public int getStatValue(ItemStack var1, EnumCADStat var2);

    public int getStoredPsi(ItemStack var1);

    public void regenPsi(ItemStack var1, int var2);

    public int consumePsi(ItemStack var1, int var2);

    public int getMemorySize(ItemStack var1);

    public void setStoredVector(ItemStack var1, int var2, Vector3 var3) throws SpellRuntimeException;

    public Vector3 getStoredVector(ItemStack var1, int var2) throws SpellRuntimeException;

    public int getTime(ItemStack var1);

    public void incrementTime(ItemStack var1);

    @OnlyIn(value=Dist.CLIENT)
    public int getSpellColor(ItemStack var1);

    public boolean craft(ItemStack var1, Player var2, PieceCraftingTrick var3);
}

