/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.internal;

import java.util.LinkedHashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public final class MathHelper {
    public static float pointDistancePlane(double x1, double y1, double x2, double y2) {
        return (float)Math.hypot(x1 - x2, y1 - y2);
    }

    public static double pointDistanceSpace(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0) + Math.pow(z1 - z2, 2.0));
    }

    public static LinkedHashSet<BlockPos> getBlocksAlongRay(Vec3 origin, Vec3 end, int maxBlocks) {
        LinkedHashSet<BlockPos> positions = new LinkedHashSet<BlockPos>();
        if (maxBlocks == 0) {
            return positions;
        }
        if (origin.equals((Object)end)) {
            positions.add(new BlockPos((int)origin.x, (int)origin.y, (int)origin.z));
        } else {
            double endX = end.x;
            double endY = end.y;
            double endZ = end.z;
            double originX = origin.x;
            double originY = origin.y;
            double originZ = origin.z;
            int blockX = Mth.floor((double)originX);
            int blockY = Mth.floor((double)originY);
            int blockZ = Mth.floor((double)originZ);
            BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(blockX, blockY, blockZ);
            positions.add(blockPos.immutable());
            double lengthX = endX - originX;
            double lengthY = endY - originY;
            double lengthZ = endZ - originZ;
            int signumX = Mth.sign((double)lengthX);
            int signumY = Mth.sign((double)lengthY);
            int signumZ = Mth.sign((double)lengthZ);
            double stepSizeX = signumX == 0 ? Double.MAX_VALUE : (double)signumX / lengthX;
            double stepSizeY = signumY == 0 ? Double.MAX_VALUE : (double)signumY / lengthY;
            double stepSizeZ = signumZ == 0 ? Double.MAX_VALUE : (double)signumZ / lengthZ;
            double totalStepsX = stepSizeX * (signumX > 0 ? 1.0 - Mth.frac((double)originX) : Mth.frac((double)originX));
            double totalStepsY = stepSizeY * (signumY > 0 ? 1.0 - Mth.frac((double)originY) : Mth.frac((double)originY));
            double totalStepsZ = stepSizeZ * (signumZ > 0 ? 1.0 - Mth.frac((double)originZ) : Mth.frac((double)originZ));
            while ((totalStepsX <= 1.0 || totalStepsY <= 1.0 || totalStepsZ <= 1.0) && positions.size() != maxBlocks) {
                if (totalStepsX < totalStepsY) {
                    if (totalStepsX < totalStepsZ) {
                        blockX += signumX;
                        totalStepsX += stepSizeX;
                    } else {
                        blockZ += signumZ;
                        totalStepsZ += stepSizeZ;
                    }
                } else if (totalStepsY < totalStepsZ) {
                    blockY += signumY;
                    totalStepsY += stepSizeY;
                } else {
                    blockZ += signumZ;
                    totalStepsZ += stepSizeZ;
                }
                blockPos.set(blockX, blockY, blockZ);
                positions.add(blockPos.immutable());
            }
        }
        return positions;
    }
}

