/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.api.spell;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;

public interface ISpellAcceptor {
    public static boolean isAcceptor(ItemStack stack) {
        return !stack.isEmpty() && Objects.nonNull(stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY));
    }

    public static boolean isContainer(ItemStack stack) {
        ISpellAcceptor capability = (ISpellAcceptor)stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.castableFromSocket();
    }

    public static boolean hasSpell(ItemStack stack) {
        ISpellAcceptor capability = (ISpellAcceptor)stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY);
        if (capability == null) {
            return false;
        }
        return capability.containsSpell();
    }

    public static ISpellAcceptor acceptor(ItemStack stack) {
        return Objects.requireNonNull((ISpellAcceptor)stack.getCapability(PsiAPI.SPELL_ACCEPTOR_CAPABILITY));
    }

    public void setSpell(Player var1, Spell var2);

    default public boolean castableFromSocket() {
        return false;
    }

    @Nullable
    default public Spell getSpell() {
        return null;
    }

    default public boolean containsSpell() {
        return false;
    }

    default public ArrayList<Entity> castSpell(SpellContext context) {
        return null;
    }

    default public boolean loopcastSpell(SpellContext context) {
        this.castSpell(context);
        return false;
    }

    default public double getCostModifier() {
        return 1.0;
    }

    default public boolean isCADOnlyContainer() {
        return false;
    }

    default public boolean requiresSneakForSpellSet() {
        return false;
    }
}

