/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.patchouli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.IVariable;
import vazkii.psi.api.spell.SpellPiece;

public class PatchouliUtils {
    public static IVariable interweaveIngredients(List<Ingredient> ingredients, int longestIngredientSize, HolderLookup.Provider registries) {
        if (ingredients.size() == 1) {
            return IVariable.wrapList((Iterable)Arrays.stream(ingredients.getFirst().getItems()).map(d -> IVariable.from((Object)d, (HolderLookup.Provider)registries)).collect(Collectors.toList()), (HolderLookup.Provider)registries);
        }
        ItemStack[] empty = new ItemStack[]{ItemStack.EMPTY};
        ArrayList<ItemStack[]> stacks = new ArrayList<ItemStack[]>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.isEmpty()) {
                stacks.add(ingredient.getItems());
                continue;
            }
            stacks.add(empty);
        }
        ArrayList<IVariable> list = new ArrayList<IVariable>(stacks.size() * longestIngredientSize);
        for (int i = 0; i < longestIngredientSize; ++i) {
            for (ItemStack[] stack : stacks) {
                list.add(IVariable.from((Object)stack[i % stack.length], (HolderLookup.Provider)registries));
            }
        }
        return IVariable.wrapList(list, (HolderLookup.Provider)registries);
    }

    public static void setPieceTooltip(IComponentRenderContext context, SpellPiece piece) {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        piece.getTooltip(tooltip);
        context.setHoverTooltipComponents(tooltip);
    }
}

