/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client.radial;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.gigaherz.toolbelt.client.radial.DrawingContext;
import dev.gigaherz.toolbelt.client.radial.GenericRadialMenu;
import dev.gigaherz.toolbelt.client.radial.TextRadialMenuItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class ItemStackRadialMenuItem
extends TextRadialMenuItem {
    private final int slot;
    private final ItemStack stack;

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ItemStackRadialMenuItem(GenericRadialMenu owner, int slot, ItemStack stack, Component altText) {
        super(owner, altText, Integer.MAX_VALUE);
        this.slot = slot;
        this.stack = stack;
    }

    @Override
    public void draw(DrawingContext context) {
        if (this.stack.getCount() > 0) {
            Matrix4fStack viewModelPose = RenderSystem.getModelViewStack();
            viewModelPose.pushMatrix();
            viewModelPose.mul((Matrix4fc)context.graphics.pose().last().pose());
            viewModelPose.translate(-8.0f, -8.0f, context.z);
            RenderSystem.applyModelViewMatrix();
            context.graphics.renderItem(this.stack, (int)context.x, (int)context.y);
            context.graphics.renderItemDecorations(context.font, this.stack, (int)context.x, (int)context.y, "");
            viewModelPose.popMatrix();
            RenderSystem.applyModelViewMatrix();
        } else {
            super.draw(context);
        }
    }

    @Override
    public void drawTooltips(DrawingContext context) {
        if (this.stack.getCount() > 0) {
            context.graphics.renderTooltip(context.font, this.stack, (int)context.x, (int)context.y);
        } else {
            super.drawTooltips(context);
        }
    }
}

