/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.actuallyadditions.api.lens.ILensItem;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityAtomicReconstructor;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;

public class ReconstructorRenderer
implements BlockEntityRenderer<TileEntityAtomicReconstructor> {
    public ReconstructorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityAtomicReconstructor tile, float partialTicks, @Nonnull PoseStack matrices, @Nonnull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        if (!tile.getLevel().getBlockState(tile.getBlockPos()).is(ActuallyBlocks.ATOMIC_RECONSTRUCTOR.get())) {
            return;
        }
        ItemStack stack = tile.inv.getStackInSlot(0);
        Direction direction = tile.getOrientation();
        float rot = 360.0f - direction.getOpposite().toYRot();
        float pitch = 0.0f;
        if (direction == Direction.UP) {
            pitch = 90.0f;
        } else if (direction == Direction.DOWN) {
            pitch = -90.0f;
        }
        if (stack.isEmpty() || !(stack.getItem() instanceof ILensItem)) {
            return;
        }
        matrices.pushPose();
        matrices.translate(0.5f, 0.5f, 0.45f);
        matrices.mulPose(Axis.YP.rotationDegrees(rot));
        matrices.mulPose(Axis.XP.rotationDegrees(pitch));
        matrices.translate(0.0f, 0.0f, -0.5f);
        matrices.scale(0.5f, 0.5f, 0.5f);
        int lightColor = LevelRenderer.getLightColor((BlockAndTintGetter)tile.getLevel(), (BlockPos)tile.getPosition().relative(direction));
        AssetUtil.renderItemInWorld(stack, lightColor, combinedOverlay, matrices, buffer);
        matrices.popPose();
    }
}

