/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.item;

import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.StorageCell;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.UpgradeInventories;
import appeng.core.localization.PlayerMessages;
import appeng.items.AEBaseItem;
import appeng.items.storage.StorageTier;
import appeng.recipes.game.StorageCellDisassemblyRecipe;
import es.degrassi.appexp.api.item.IExperienceCellItem;
import es.degrassi.appexp.me.cell.ExperienceCellHandler;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ExperienceStorageCell
extends AEBaseItem
implements IExperienceCellItem {
    private final StorageTier tier;

    public ExperienceStorageCell(Item.Properties properties, StorageTier tier) {
        super(properties);
        this.tier = tier;
    }

    public IUpgradeInventory getUpgrades(ItemStack stack) {
        return UpgradeInventories.forItem((ItemStack)stack, (int)1);
    }

    @Override
    public long getTotalBytes() {
        return 100L * (long)Math.pow(4.0, this.tier.index() - 1);
    }

    @Override
    public double getIdleDrain() {
        return this.tier.idleDrain();
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack inHand = player.getItemInHand(hand);
        this.disassemble(inHand, level, player);
        return new InteractionResultHolder(InteractionResult.sidedSuccess((boolean)level.isClientSide()), (Object)inHand);
    }

    @NotNull
    public InteractionResult onItemUseFirst(@NotNull ItemStack stack, UseOnContext context) {
        return this.disassemble(stack, context.getLevel(), context.getPlayer()) ? InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide()) : InteractionResult.PASS;
    }

    private boolean disassemble(ItemStack stack, Level level, Player player) {
        if (player != null && player.isShiftKeyDown()) {
            if (level.isClientSide()) {
                return false;
            }
            List disassembledStacks = StorageCellDisassemblyRecipe.getDisassemblyResult((Level)level, (Item)stack.getItem());
            if (disassembledStacks.isEmpty()) {
                return false;
            }
            Inventory playerInv = player.getInventory();
            StorageCell cellInv = StorageCells.getCellInventory((ItemStack)stack, null);
            if (cellInv != null && playerInv.getSelected() == stack) {
                if (cellInv.getAvailableStacks().isEmpty()) {
                    playerInv.setItem(playerInv.selected, ItemStack.EMPTY);
                    for (ItemStack upgrade : this.getUpgrades(stack)) {
                        playerInv.placeItemBackInInventory(upgrade);
                    }
                    for (ItemStack disassembled : disassembledStacks) {
                        playerInv.placeItemBackInInventory(disassembled);
                    }
                    return true;
                }
                player.displayClientMessage((Component)PlayerMessages.OnlyEmptyCellsCanBeDisassembled.text(), true);
            }
        }
        return false;
    }

    @ParametersAreNonnullByDefault
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag advTooltips) {
        ExperienceCellHandler.INSTANCE.addCellInformationToTooltip(stack, lines);
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        return ExperienceCellHandler.INSTANCE.getTooltipImage(stack);
    }

    @Generated
    public StorageTier getTier() {
        return this.tier;
    }
}

