/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.me.misc;

import appeng.api.AECapabilities;
import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import es.degrassi.appexp.me.key.ExperienceKey;
import es.degrassi.experiencelib.api.capability.ExperienceLibCapabilities;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public record GenericStackExperienceStorage(GenericInternalInventory inv) implements IExperienceHandler
{
    public static void registerCapability(RegisterCapabilitiesEvent event) {
        for (Block block : BuiltInRegistries.BLOCK) {
            if (!event.isBlockRegistered(AECapabilities.GENERIC_INTERNAL_INV, block)) continue;
            event.registerBlock(ExperienceLibCapabilities.EXPERIENCE.block(), (level, pos, state, be, context) -> {
                GenericInternalInventory genericInv = (GenericInternalInventory)level.getCapability(AECapabilities.GENERIC_INTERNAL_INV, pos, state, be, context);
                return genericInv != null ? new GenericStackExperienceStorage(genericInv) : null;
            }, new Block[]{block});
        }
    }

    public int getTanks() {
        return 1;
    }

    public boolean canAcceptExperience(int tank, long experience) {
        return this.insert(1L, Actionable.SIMULATE) > 0L;
    }

    public boolean canProvideExperience(int tank, long experience) {
        return this.extract(1L, Actionable.SIMULATE) > 0L;
    }

    public long getMaxExtract(int tank) {
        return Integer.MAX_VALUE;
    }

    public long getMaxReceive(int tank) {
        return Integer.MAX_VALUE;
    }

    public long getExperience() {
        return this.extract(Integer.MAX_VALUE, Actionable.SIMULATE);
    }

    public long getExperienceCapacity() {
        int slots = 0;
        for (int i = 0; i < this.inv.size(); ++i) {
            AEKey key = this.inv.getKey(i);
            if (key != null && key != ExperienceKey.KEY) continue;
            ++slots;
        }
        return (long)slots * this.inv.getMaxAmount((AEKey)ExperienceKey.KEY);
    }

    public void setExperience(int tank, long experience) {
        throw new UnsupportedOperationException();
    }

    public void setCapacity(int tank, long l) {
        throw new UnsupportedOperationException();
    }

    public long receiveExperience(int tank, long experience, boolean simulate) {
        return this.insert(experience, Actionable.ofSimulate((boolean)simulate));
    }

    public long extractExperience(int tank, long experience, boolean simulate) {
        return this.extract(experience, Actionable.ofSimulate((boolean)simulate));
    }

    public long extractExperienceRecipe(int tank, long experience, boolean simulate) {
        return this.insert(experience, Actionable.ofSimulate((boolean)simulate));
    }

    public long receiveExperienceRecipe(int tank, long experience, boolean simulate) {
        return this.extract(experience, Actionable.ofSimulate((boolean)simulate));
    }

    private long insert(long amount, Actionable mode) {
        long inserted = 0L;
        for (int i = 0; i < this.inv.size() && inserted < amount; inserted += this.inv.insert(i, (AEKey)ExperienceKey.KEY, amount - inserted, mode), ++i) {
        }
        return inserted;
    }

    private long extract(long amount, Actionable mode) {
        long extracted = 0L;
        for (int i = 0; i < this.inv.size() && extracted < amount; extracted += this.inv.extract(i, (AEKey)ExperienceKey.KEY, amount - extracted, mode), ++i) {
        }
        return extracted;
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return new CompoundTag();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
    }
}

