/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import appeng.client.render.DelegateBakedModel;
import appeng.client.render.cablebus.FacadeBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class FacadeBakedItemModel
extends DelegateBakedModel {
    private final ItemStack textureStack;
    private final FacadeBuilder facadeBuilder;
    private List<BakedQuad> quads = null;

    protected FacadeBakedItemModel(BakedModel base, ItemStack textureStack, FacadeBuilder facadeBuilder) {
        super(base);
        this.textureStack = textureStack;
        this.facadeBuilder = facadeBuilder;
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getQuads(state, side, rand, ModelData.EMPTY, null);
    }

    @Override
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, RenderType renderType) {
        if (side != null) {
            return Collections.emptyList();
        }
        if (this.quads == null) {
            this.quads = new ArrayList<BakedQuad>();
            this.quads.addAll(this.facadeBuilder.buildFacadeItemQuads(this.textureStack, Direction.NORTH).toBakedBlockQuads());
            this.quads.addAll(this.getBaseModel().getQuads(state, side, rand, data, renderType));
            this.quads = Collections.unmodifiableList(this.quads);
        }
        return this.quads;
    }

    @Override
    public boolean isGui3d() {
        return false;
    }

    @Override
    public boolean usesBlockLight() {
        return false;
    }

    @Override
    public boolean isCustomRenderer() {
        return false;
    }

    @Override
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }
}

