/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen.perk;

import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.perk.PerkAllocation;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class PerkInfoPanel {
    private final SpellSchool school;
    private final PlayerAffinityData affinityData;
    private final Map<String, PerkAllocation> allocatedPerks;

    public PerkInfoPanel(SpellSchool school, PlayerAffinityData affinityData, Map<String, PerkAllocation> allocatedPerks) {
        this.school = school;
        this.affinityData = affinityData;
        this.allocatedPerks = allocatedPerks;
    }

    public void render(GuiGraphics guiGraphics, Font font, int width, int height) {
        int panelX = 10;
        int panelY = height - 80;
        int panelWidth = 200;
        int panelHeight = 70;
        guiGraphics.fill(panelX, panelY, panelX + panelWidth, panelY + panelHeight, Integer.MIN_VALUE);
        guiGraphics.drawString(font, this.school.getTextComponent(), panelX + 5, panelY + 5, 0xFFFFFF);
        int availablePoints = this.affinityData.getAvailablePoints(this.school);
        int totalPoints = this.affinityData.getSchoolPoints(this.school);
        guiGraphics.drawString(font, "Available: " + availablePoints, panelX + 5, panelY + 20, 0xFFFFFF);
        guiGraphics.drawString(font, "Total: " + totalPoints, panelX + 5, panelY + 35, 0xFFFFFF);
        int allocatedCount = this.allocatedPerks.size();
        guiGraphics.drawString(font, "Perks: " + allocatedCount, panelX + 5, panelY + 50, 0xFFFFFF);
    }
}

