/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.ability;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerk;
import com.github.ars_affinity.registry.ModPotions;
import com.github.ars_affinity.registry.ModSounds;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectColdSnap;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class IceBlastHelper {
    public static void executeAbility(ServerPlayer player, AffinityPerk.ActiveAbilityPerk perk) {
        double maxMana;
        double requiredMana;
        ArsAffinity.LOGGER.info("ICE BLAST: Starting execution for player {} with perk: damage={}, freezeTime={}, radius={}, cooldown={}", (Object)player.getName().getString(), (Object)Float.valueOf(perk.damage), (Object)perk.freezeTime, (Object)Float.valueOf(perk.radius), (Object)perk.cooldown);
        IManaCap manaCap = (IManaCap)player.getCapability(CapabilityRegistry.MANA_CAPABILITY);
        if (manaCap == null) {
            ArsAffinity.LOGGER.info("ICE BLAST: Player {} has no mana capability", (Object)player.getName().getString());
            return;
        }
        double currentMana = manaCap.getCurrentMana();
        if (currentMana < (requiredMana = (double)perk.manaCost * (maxMana = (double)manaCap.getMaxMana()))) {
            ArsAffinity.LOGGER.info("ICE BLAST: Player {} doesn't have enough mana. Required: {}, Current: {}", (Object)player.getName().getString(), (Object)requiredMana, (Object)currentMana);
            return;
        }
        if (IceBlastHelper.isPlayerOnCooldown(player)) {
            return;
        }
        IceBlastHelper.applyCooldown(player, perk.cooldown);
        float manaScaling = IceBlastHelper.calculateManaScaling(player, perk.damage);
        float scaledDamage = perk.damage * manaScaling;
        int scaledFreezeTime = (int)((float)perk.freezeTime * manaScaling);
        float scaledRadius = perk.radius * manaScaling;
        IceBlastHelper.damageEntitiesInRange(player, scaledDamage, scaledFreezeTime, scaledRadius);
        IceBlastHelper.placeSnowAroundPlayer(player);
        IceBlastHelper.extinguishPlayerFire(player);
        IceBlastHelper.extinguishAreaFires(player);
        IceBlastHelper.convertLavaToObsidian(player);
        IceBlastHelper.freezeAreaWater(player);
        IceBlastHelper.spawnParticleEffects(player);
        IceBlastHelper.playSoundEffects(player);
        IceBlastHelper.consumeMana(player, perk);
    }

    private static boolean isPlayerOnCooldown(ServerPlayer player) {
        return player.hasEffect(ModPotions.ICE_BLAST_COOLDOWN_EFFECT);
    }

    private static void applyCooldown(ServerPlayer player, int cooldownTicks) {
        player.addEffect(new MobEffectInstance(ModPotions.ICE_BLAST_COOLDOWN_EFFECT, cooldownTicks, 0, false, true, true));
    }

    private static float calculateManaScaling(ServerPlayer player, float baseValue) {
        IManaCap manaCap = (IManaCap)player.getCapability(CapabilityRegistry.MANA_CAPABILITY);
        if (manaCap == null) {
            return 0.0f;
        }
        int currentMana = (int)manaCap.getCurrentMana();
        int maxMana = manaCap.getMaxMana();
        if (maxMana <= 0) {
            return 0.0f;
        }
        float manaPercentage = (float)currentMana / (float)maxMana;
        return baseValue * manaPercentage;
    }

    private static void damageEntitiesInRange(ServerPlayer player, float damage, int freezeTime, float radius) {
        Vec3 playerPos = player.position();
        AABB scanArea = new AABB(playerPos.x - 2.0, playerPos.y - 2.0, playerPos.z - 2.0, playerPos.x + 2.0, playerPos.y + 2.0, playerPos.z + 2.0);
        List entitiesInRange = player.level().getEntities((Entity)player, scanArea, entity -> entity instanceof LivingEntity && entity != player && !entity.isAlliedTo((Entity)player));
        for (Entity entity2 : entitiesInRange) {
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            IceBlastHelper.applyEntityEffects(livingEntity, damage, freezeTime);
        }
    }

    private static void applyEntityEffects(LivingEntity entity, float damage, int freezeTime) {
        IceBlastHelper.applyFreezingEffect(entity, freezeTime);
        IceBlastHelper.applySlownessEffect(entity, 200);
        IceBlastHelper.applySpellDamage(entity, damage);
    }

    private static void applyFreezingEffect(LivingEntity entity, int duration) {
        entity.setTicksFrozen(entity.getTicksFrozen() + duration);
    }

    private static void applySlownessEffect(LivingEntity entity, int duration) {
        entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration, 0, false, false, false));
    }

    private static void applySpellDamage(LivingEntity entity, float damage) {
        Spell spell = new Spell();
        spell = spell.add((AbstractSpellPart)MethodTouch.INSTANCE);
        spell = spell.add((AbstractSpellPart)EffectColdSnap.INSTANCE);
        SpellContext context = SpellContext.fromEntity((Spell)spell, (LivingEntity)entity, (ItemStack)entity.getMainHandItem());
        SpellResolver resolver = new SpellResolver(context);
        resolver.onResolveEffect(entity.level(), (HitResult)new EntityHitResult((Entity)entity));
    }

    private static void placeSnowAroundPlayer(ServerPlayer player) {
        Vec3 playerPos = player.position();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos snowPos = new BlockPos((int)playerPos.x + x, (int)playerPos.y, (int)playerPos.z + z);
                if (!IceBlastHelper.canPlaceSnow(player.level(), snowPos)) continue;
                BlockState snowState = (BlockState)Blocks.SNOW.defaultBlockState().setValue((Property)SnowLayerBlock.LAYERS, (Comparable)Integer.valueOf(1));
                player.level().setBlockAndUpdate(snowPos, snowState);
            }
        }
    }

    private static boolean canPlaceSnow(Level level, BlockPos pos) {
        BlockState currentState = level.getBlockState(pos);
        BlockState belowState = level.getBlockState(pos.below());
        return currentState.isAir() && belowState.isSolidRender((BlockGetter)level, pos.below());
    }

    private static void spawnParticleEffects(ServerPlayer player) {
        Vec3 playerPos = player.position();
        Level level = player.level();
        if (level instanceof ServerLevel) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            for (i = 0; i < 20; ++i) {
                offsetX = (Math.random() - 0.5) * 4.0;
                offsetY = Math.random() * 2.0;
                offsetZ = (Math.random() - 0.5) * 4.0;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SNOWFLAKE, playerPos.x + offsetX, playerPos.y + offsetY, playerPos.z + offsetZ, 1, 0.0, 0.0, 0.0, 0.1);
            }
            for (i = 0; i < 15; ++i) {
                offsetX = (Math.random() - 0.5) * 3.0;
                offsetY = Math.random() * 1.5;
                offsetZ = (Math.random() - 0.5) * 3.0;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, playerPos.x + offsetX, playerPos.y + offsetY, playerPos.z + offsetZ, 1, 0.0, 0.0, 0.0, 0.05);
            }
        }
    }

    private static void playSoundEffects(ServerPlayer player) {
        Vec3 playerPos = player.position();
        player.level().playSound(null, playerPos.x, playerPos.y, playerPos.z, (SoundEvent)ModSounds.ICE_BLAST.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private static void extinguishPlayerFire(ServerPlayer player) {
        if (player.isOnFire()) {
            player.clearFire();
        }
    }

    private static void extinguishAreaFires(ServerPlayer player) {
        Vec3 playerPos = player.position();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos firePos = new BlockPos((int)playerPos.x + x, (int)playerPos.y + y, (int)playerPos.z + z);
                    if (!player.level().getBlockState(firePos).is(Blocks.FIRE)) continue;
                    player.level().removeBlock(firePos, false);
                }
            }
        }
    }

    private static void convertLavaToObsidian(ServerPlayer player) {
        Vec3 playerPos = player.position();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos lavaPos = new BlockPos((int)playerPos.x + x, (int)playerPos.y + y, (int)playerPos.z + z);
                    if (!player.level().getBlockState(lavaPos).is(Blocks.LAVA)) continue;
                    player.level().setBlockAndUpdate(lavaPos, Blocks.OBSIDIAN.defaultBlockState());
                }
            }
        }
    }

    private static void freezeAreaWater(ServerPlayer player) {
        Vec3 playerPos = player.position();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    BlockPos waterPos = new BlockPos((int)playerPos.x + x, (int)playerPos.y + y, (int)playerPos.z + z);
                    if (!player.level().getBlockState(waterPos).is(Blocks.WATER)) continue;
                    player.level().setBlockAndUpdate(waterPos, Blocks.ICE.defaultBlockState());
                }
            }
        }
    }

    private static void consumeMana(ServerPlayer player, AffinityPerk.ActiveAbilityPerk perk) {
        IManaCap manaCap = (IManaCap)player.getCapability(CapabilityRegistry.MANA_CAPABILITY);
        if (manaCap != null) {
            double maxMana = manaCap.getMaxMana();
            double requiredMana = (double)perk.manaCost * maxMana;
            manaCap.removeMana((double)((int)requiredMana));
        }
    }
}

