/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.event;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.perk.AffinityPerkHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.hollingsworth.arsnouveau.api.event.SummonEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;

public class PassiveSummonDefenseEvents {
    @SubscribeEvent
    public static void onSummonEvent(SummonEvent event) {
        LivingEntity livingEntity = event.shooter;
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (event.world.isClientSide()) {
            return;
        }
        if (AffinityPerkHelper.hasActivePerk(player, AffinityPerkType.PASSIVE_SUMMON_DEFENSE) && event.summon.getLivingEntity() != null) {
            int highestTier = AffinityPerkHelper.getPerkTier(player, AffinityPerkType.PASSIVE_SUMMON_DEFENSE);
            PassiveSummonDefenseEvents.equipArmorToSummon(event.summon.getLivingEntity(), highestTier, event.world);
            ArsAffinity.LOGGER.info("Player {} summoned entity with PASSIVE_SUMMON_DEFENSE perk at tier {}", (Object)player.getName().getString(), (Object)highestTier);
        }
    }

    private static void equipArmorToSummon(LivingEntity summon, int conjurationTier, Level level) {
        if (summon instanceof Horse) {
            Horse horse = (Horse)summon;
            PassiveSummonDefenseEvents.equipHorseArmor(horse, conjurationTier, level);
        } else if (summon instanceof Mob) {
            Mob mob = (Mob)summon;
            PassiveSummonDefenseEvents.equipMobArmor(mob, conjurationTier, level);
        }
    }

    private static void equipHorseArmor(Horse horse, int conjurationTier, Level level) {
        ItemStack horseArmorStack = new ItemStack((ItemLike)(switch (conjurationTier) {
            case 1 -> Items.IRON_HORSE_ARMOR;
            case 2 -> Items.GOLDEN_HORSE_ARMOR;
            case 3 -> Items.DIAMOND_HORSE_ARMOR;
            default -> Items.DIAMOND_HORSE_ARMOR;
        }));
        horse.setItemSlot(EquipmentSlot.CHEST, horseArmorStack);
        horse.setDropChance(EquipmentSlot.CHEST, 0.0f);
        ArsAffinity.LOGGER.debug("Equipped {} horse armor to summon {} for tier {}", (Object)(conjurationTier == 1 ? "iron" : (conjurationTier == 2 ? "golden" : "diamond")), (Object)horse.getType().getDescriptionId(), (Object)conjurationTier);
    }

    private static void equipMobArmor(Mob mob, int conjurationTier, Level level) {
        Item leggings;
        Item chestplate;
        Item helmet;
        Item boots = switch (conjurationTier) {
            case 1 -> {
                helmet = Items.LEATHER_HELMET;
                chestplate = Items.LEATHER_CHESTPLATE;
                leggings = Items.LEATHER_LEGGINGS;
                yield Items.LEATHER_BOOTS;
            }
            case 2 -> {
                helmet = Items.IRON_HELMET;
                chestplate = Items.IRON_CHESTPLATE;
                leggings = Items.IRON_LEGGINGS;
                yield Items.IRON_BOOTS;
            }
            case 3 -> {
                helmet = Items.NETHERITE_HELMET;
                chestplate = Items.NETHERITE_CHESTPLATE;
                leggings = Items.NETHERITE_LEGGINGS;
                yield Items.NETHERITE_BOOTS;
            }
            default -> {
                helmet = Items.NETHERITE_HELMET;
                chestplate = Items.NETHERITE_CHESTPLATE;
                leggings = Items.NETHERITE_LEGGINGS;
                yield Items.NETHERITE_BOOTS;
            }
        };
        ItemStack helmetStack = new ItemStack((ItemLike)helmet);
        ItemStack chestplateStack = new ItemStack((ItemLike)chestplate);
        ItemStack leggingsStack = new ItemStack((ItemLike)leggings);
        ItemStack bootsStack = new ItemStack((ItemLike)boots);
        mob.setItemSlot(EquipmentSlot.HEAD, helmetStack);
        mob.setItemSlot(EquipmentSlot.CHEST, chestplateStack);
        mob.setItemSlot(EquipmentSlot.LEGS, leggingsStack);
        mob.setItemSlot(EquipmentSlot.FEET, bootsStack);
        mob.setDropChance(EquipmentSlot.HEAD, 0.0f);
        mob.setDropChance(EquipmentSlot.CHEST, 0.0f);
        mob.setDropChance(EquipmentSlot.LEGS, 0.0f);
        mob.setDropChance(EquipmentSlot.FEET, 0.0f);
        ArsAffinity.LOGGER.debug("Equipped {} armor to summon {} for tier {}", (Object)(conjurationTier == 1 ? "leather" : (conjurationTier == 2 ? "iron" : "netherite")), (Object)mob.getType().getDescriptionId(), (Object)conjurationTier);
    }
}

