/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.ArsAffinity;
import com.hollingsworth.arsnouveau.api.registry.GlyphRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.common.capability.ANPlayerDataCap;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class GlyphPrerequisiteHelper {
    public static boolean hasUnlockedGlyph(Player player, String glyphId) {
        if (player == null || glyphId == null || glyphId.isEmpty()) {
            return true;
        }
        try {
            ResourceLocation glyphLocation = ResourceLocation.parse((String)glyphId);
            ANPlayerDataCap playerCap = CapabilityRegistry.getPlayerDataCap((LivingEntity)player);
            if (playerCap == null) {
                return false;
            }
            AbstractSpellPart glyph = (AbstractSpellPart)GlyphRegistry.getSpellpartMap().get(glyphLocation);
            if (glyph == null) {
                return false;
            }
            return playerCap.knowsGlyph(glyph);
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.warn("Error checking glyph prerequisite {}: {}", (Object)glyphId, (Object)e.getMessage());
            return false;
        }
    }

    public static String getGlyphDisplayName(String glyphId) {
        if (glyphId == null || glyphId.isEmpty()) {
            return "";
        }
        try {
            ResourceLocation glyphLocation = ResourceLocation.parse((String)glyphId);
            AbstractSpellPart glyph = (AbstractSpellPart)GlyphRegistry.getSpellpartMap().get(glyphLocation);
            if (glyph != null) {
                return glyph.getName();
            }
            String[] parts = glyphId.split(":");
            if (parts.length >= 2) {
                String glyphName = parts[1].replace("glyph_", "");
                return glyphName.substring(0, 1).toUpperCase() + glyphName.substring(1);
            }
            return glyphId;
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.warn("Error getting glyph display name for {}: {}", (Object)glyphId, (Object)e.getMessage());
            return glyphId;
        }
    }
}

