/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.ai;

import alexthw.ars_elemental.common.entity.MermaidEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.phys.Vec3;

public class DolphinJumpGoal
extends JumpGoal {
    private static final int[] STEPS_TO_CHECK = new int[]{0, 1, 4, 5, 6, 7};
    private final MermaidEntity dolphin;
    private final int interval;

    public DolphinJumpGoal(MermaidEntity pDolphin, int pInterval) {
        this.dolphin = pDolphin;
        this.interval = DolphinJumpGoal.reducedTickDelay((int)pInterval);
    }

    public boolean canUse() {
        if (this.dolphin.getRandom().nextInt(this.interval) != 0) {
            return false;
        }
        Direction direction = this.dolphin.getMotionDirection();
        int i = direction.getStepX();
        int j = direction.getStepZ();
        BlockPos blockpos = this.dolphin.blockPosition();
        for (int k : STEPS_TO_CHECK) {
            if (this.waterIsClear(blockpos, i, j, k) && this.surfaceIsClear(blockpos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    private boolean waterIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
        BlockPos blockpos = pPos.offset(pDx * pScale, 0, pDz * pScale);
        return this.dolphin.level.getFluidState(blockpos).is(FluidTags.WATER) && !this.dolphin.level.getBlockState(blockpos).blocksMotion();
    }

    private boolean surfaceIsClear(BlockPos pPos, int pDx, int pDz, int pScale) {
        return this.dolphin.level.getBlockState(pPos.offset(pDx * pScale, 1, pDz * pScale)).isAir() && this.dolphin.level.getBlockState(pPos.offset(pDx * pScale, 2, pDz * pScale)).isAir();
    }

    public boolean canContinueToUse() {
        double d0 = this.dolphin.getDeltaMovement().y;
        return !(d0 * d0 < (double)0.03f && this.dolphin.getXRot() != 0.0f && Math.abs(this.dolphin.getXRot()) < 10.0f && this.dolphin.isInWater() || this.dolphin.onGround());
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        Direction direction = this.dolphin.getMotionDirection();
        this.dolphin.setDeltaMovement(this.dolphin.getDeltaMovement().add((double)direction.getStepX() * 0.5, 0.8, (double)direction.getStepZ() * 0.5));
        this.dolphin.getNavigation().stop();
    }

    public void stop() {
        this.dolphin.setXRot(0.0f);
    }

    public void tick() {
        Vec3 vec3 = this.dolphin.getDeltaMovement();
        if (vec3.y * vec3.y < (double)0.03f && this.dolphin.getXRot() != 0.0f) {
            this.dolphin.setXRot(Mth.rotLerp((float)this.dolphin.getXRot(), (float)0.0f, (float)0.2f));
        } else if (vec3.length() > (double)1.0E-5f) {
            double d0 = vec3.horizontalDistance();
            double d1 = Math.atan2(-vec3.y, d0) * 57.2957763671875;
            this.dolphin.setXRot((float)d1);
        }
    }
}

