/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.mob_effects;

import alexthw.ars_elemental.registry.ModPotions;
import com.alexthw.sauce.util.PosCarryMEI;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class RepelEffect
extends MobEffect {
    public RepelEffect() {
        super(MobEffectCategory.NEUTRAL, new ParticleColor(255, 255, 0).getColor());
    }

    private static void repel(LivingEntity entity, BlockPos origin) {
        Vec3 dist = new Vec3(entity.getX() - (double)origin.getX(), entity.getY() - (double)origin.getY(), entity.getZ() - (double)origin.getZ());
        if (dist.length() < 15.0) {
            entity.setDeltaMovement(entity.getDeltaMovement().add(dist.normalize()).scale(0.5));
            entity.hurtMarked = true;
        }
    }

    public boolean applyEffectTick(LivingEntity entity, int pAmplifier) {
        MobEffectInstance mobEffectInstance = entity.getEffect(ModPotions.REPEL);
        if (!(mobEffectInstance instanceof PosCarryMEI)) {
            return false;
        }
        PosCarryMEI mei = (PosCarryMEI)mobEffectInstance;
        for (BlockPos blockPos : mei.getAllOrigins()) {
            RepelEffect.repel(entity, blockPos);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int pDuration, int pAmplifier) {
        return true;
    }
}

