/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.renderer.tile;

import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.DecorBlossomTile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoBlockRenderer;

public class BlossomRenderer
extends GeoBlockRenderer<DecorBlossomTile> {
    public BlossomRenderer(BlockEntityRendererProvider.Context rendererProvider) {
        super(new GenericModel("decor_blossom"));
    }

    public void actuallyRender(PoseStack poseStack, DecorBlossomTile animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        Direction direction = (Direction)animatable.getBlockState().getValue((Property)BasicSpellTurret.FACING);
        switch (direction) {
            case UP: {
                poseStack.translate(0.0f, 0.0f, 0.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case DOWN: {
                poseStack.translate(0.0f, 1.0f, 0.0f);
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case NORTH: {
                poseStack.translate(0.0, 0.5, 0.5);
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                poseStack.translate(-0.5, 0.5, 0.0);
                poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                poseStack.translate(0.5, 0.5, 0.0);
                poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                break;
            }
            case SOUTH: {
                poseStack.translate(0.0, 0.5, -0.5);
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                poseStack.mulPose(Axis.ZP.rotationDegrees(-180.0f));
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        super.actuallyRender(poseStack, (BlockEntity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
        poseStack.popPose();
    }
}

