/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.crafting.recipes;

import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.RecipeRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnchantmentRecipe
extends EnchantingApparatusRecipe {
    public ResourceKey<Enchantment> enchantmentKey;
    public int enchantLevel;

    public EnchantmentRecipe(List<Ingredient> pedestalItems, ResourceKey<Enchantment> enchantmentKey, int level, int source) {
        super(Ingredient.EMPTY, ItemStack.EMPTY, pedestalItems, source, true);
        this.enchantmentKey = enchantmentKey;
        this.enchantLevel = level;
    }

    @Override
    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.ENCHANTMENT_TYPE.get();
    }

    @Override
    public boolean excludeJei() {
        return true;
    }

    @Override
    public boolean matches(ApparatusRecipeInput input, Level level, @Nullable Player player) {
        return this.doPedestalsMatch(input) && this.doesReagentMatch(input, level, player);
    }

    public Holder<Enchantment> holderFor(Level level) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(this.enchantmentKey);
    }

    @Override
    public boolean doesReagentMatch(ApparatusRecipeInput input, Level world, @javax.annotation.Nullable Player player) {
        ItemStack stack = input.catalyst();
        if (stack.isEmpty()) {
            return false;
        }
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        Holder<Enchantment> enchantment = this.holderFor(world);
        int level = enchantments.getLevel(enchantment);
        Collection enchantList = enchantments.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        enchantList.remove(enchantment);
        if (stack.getItem() != Items.BOOK && stack.getItem() != Items.ENCHANTED_BOOK && !((Enchantment)enchantment.value()).canEnchant(stack)) {
            if (player != null) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.enchanting.incompatible"));
            }
            return false;
        }
        if (!EnchantmentHelper.isEnchantmentCompatible((Collection)enchantList, enchantment)) {
            if (player != null) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.enchanting.incompatible"));
            }
            return false;
        }
        if (this.enchantLevel - level != 1) {
            if (player != null) {
                PortUtil.sendMessage((Entity)player, (Component)Component.translatable((String)"ars_nouveau.enchanting.bad_level"));
            }
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public ItemStack assemble(ApparatusRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider lookup) {
        ItemStack inStack = input.catalyst();
        ItemStack stack = inStack.getItem() == Items.BOOK ? new ItemStack((ItemLike)Items.ENCHANTED_BOOK) : inStack.copy();
        ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)stack);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(enchantments);
        Holder.Reference enchantment = lookup.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(this.enchantmentKey);
        mutable.set((Holder)enchantment, this.enchantLevel);
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)mutable.toImmutable());
        return stack;
    }

    @Override
    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Override
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.ENCHANTMENT_SERIALIZER.get();
    }

    public ResourceKey<Enchantment> enchantmentKey() {
        return this.enchantmentKey;
    }

    public int enchantLevel() {
        return this.enchantLevel;
    }

    public static class Serializer
    implements RecipeSerializer<EnchantmentRecipe> {
        public static MapCodec<EnchantmentRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().fieldOf("pedestalItems").forGetter(EnchantingApparatusRecipe::pedestalItems), (App)ResourceKey.codec((ResourceKey)Registries.ENCHANTMENT).fieldOf("enchantment").forGetter(EnchantmentRecipe::enchantmentKey), (App)Codec.INT.fieldOf("level").forGetter(EnchantmentRecipe::enchantLevel), (App)Codec.INT.fieldOf("sourceCost").forGetter(EnchantingApparatusRecipe::sourceCost)).apply((Applicative)instance, EnchantmentRecipe::new));
        public static StreamCodec<RegistryFriendlyByteBuf, EnchantmentRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.collection(ArrayList::new)), EnchantingApparatusRecipe::pedestalItems, (StreamCodec)ResourceKey.streamCodec((ResourceKey)Registries.ENCHANTMENT), EnchantmentRecipe::enchantmentKey, (StreamCodec)ByteBufCodecs.INT, EnchantmentRecipe::enchantLevel, (StreamCodec)ByteBufCodecs.INT, EnchantingApparatusRecipe::sourceCost, EnchantmentRecipe::new);

        @NotNull
        public MapCodec<EnchantmentRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, EnchantmentRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

