/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.entity.goal.familiar;

import com.hollingsworth.arsnouveau.common.entity.familiar.FamiliarEntity;
import com.hollingsworth.arsnouveau.common.entity.goal.familiar.FamiliarBaseGoal;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;

public class FamiliarFollowGoal
extends FamiliarBaseGoal {
    private LivingEntity theOwner;
    private final float maxDist;
    private final float minDist;
    double moveSpeed;

    public FamiliarFollowGoal(FamiliarEntity entityRobit, double moveSpeed, float min, float max) {
        super(entityRobit);
        this.moveSpeed = moveSpeed;
        this.minDist = min;
        this.maxDist = max;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    @Override
    public boolean canUse() {
        LivingEntity player = this.entity.getOwner();
        if (player == null || player.isSpectator()) {
            return false;
        }
        if (this.entity.level.dimension() != player.level.dimension()) {
            return false;
        }
        if (this.entity.distanceToSqr((Entity)player) < (double)(this.minDist * this.minDist)) {
            return false;
        }
        this.theOwner = player;
        return true;
    }

    public boolean canContinueToUse() {
        boolean stillRunning;
        boolean bl = stillRunning = !this.entity.getNavigation().isDone() && this.entity.distanceToSqr((Entity)this.theOwner) > (double)(this.maxDist * this.maxDist) && this.theOwner.level.dimension() == this.entity.level.dimension();
        if (!stillRunning) {
            this.entity.getNavigation().stop();
        }
        return stillRunning;
    }

    public void stop() {
        this.theOwner = null;
        super.stop();
    }

    public void tick() {
        this.entity.getLookControl().setLookAt((Entity)this.theOwner, 6.0f, (float)this.entity.getMaxHeadXRot() / 10.0f);
        if (!this.entity.isPassenger()) {
            if (this.entity.distanceToSqr((Entity)this.theOwner) >= 144.0 && this.entity.canTeleport()) {
                BlockPos targetPos = this.theOwner.blockPosition();
                this.teleportTo((Entity)this.entity, targetPos.getX(), targetPos.getY(), targetPos.getZ());
            } else {
                this.entity.getNavigation().moveTo((Entity)this.theOwner, this.moveSpeed);
            }
        }
    }

    private int randomize(int min, int max) {
        return this.entity.getRandom().nextInt(max - min + 1) + min;
    }

    private void teleportTo(Entity target, int x, int y, int z) {
        this.entity.setPos(x, (double)y + 0.5, z);
        this.entity.getNavigation().stop();
    }
}

