/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.items;

import com.hollingsworth.arsnouveau.api.event.EventQueue;
import com.hollingsworth.arsnouveau.client.jei.AliasProvider;
import com.hollingsworth.arsnouveau.common.event.timed.BuildPortalEvent;
import com.hollingsworth.arsnouveau.common.items.ModItem;
import com.hollingsworth.arsnouveau.common.items.WarpScroll;
import com.hollingsworth.arsnouveau.common.items.data.WarpScrollData;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StableWarpScroll
extends ModItem
implements AliasProvider {
    public StableWarpScroll(Item.Properties properties) {
        super(properties.stacksTo(1).component(DataComponentRegistry.WARP_SCROLL, (Object)new WarpScrollData(true)));
    }

    public boolean onEntityItemUpdate(@NotNull ItemStack stack, @NotNull ItemEntity entity) {
        return ((WarpScroll)ItemsRegistry.WARP_SCROLL.get()).onEntityItemUpdate(stack, entity);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        WarpScrollData data = (WarpScrollData)stack.get(DataComponentRegistry.WARP_SCROLL);
        if (data != null && !data.crossDim()) {
            stack.set(DataComponentRegistry.WARP_SCROLL, (Object)data.withCrossDim(true));
        }
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (!context.getLevel().isClientSide) {
            WarpScrollData scrollData = (WarpScrollData)context.getItemInHand().get(DataComponentRegistry.WARP_SCROLL);
            if (!scrollData.isValid()) {
                return InteractionResult.FAIL;
            }
            EventQueue.getServerInstance().addEvent(new BuildPortalEvent(context.getLevel(), context.getClickedPos(), context.getPlayer().getDirection().getClockWise(), scrollData));
            context.getLevel().playSound(null, context.getClickedPos(), SoundEvents.ILLUSIONER_CAST_SPELL, context.getPlayer().getSoundSource(), 1.0f, 1.0f);
        }
        return super.useOn(context);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, @NotNull Player player, @NotNull InteractionHand pUsedHand) {
        if (pUsedHand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.success((Object)player.getItemInHand(pUsedHand));
        }
        ItemStack stack = player.getItemInHand(InteractionHand.MAIN_HAND);
        WarpScrollData data = (WarpScrollData)stack.get(DataComponentRegistry.WARP_SCROLL);
        if (!(pLevel instanceof ServerLevel)) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        ServerLevel serverLevel = (ServerLevel)pLevel;
        if (player.isShiftKeyDown() && !data.isValid()) {
            stack.set(DataComponentRegistry.WARP_SCROLL, (Object)new WarpScrollData(Optional.of(player.blockPosition()), player.getCommandSenderWorld().dimension().location().toString(), player.getRotationVector(), true));
            player.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.warp_scroll.recorded"));
        } else if (player.isShiftKeyDown() && data.isValid()) {
            player.sendSystemMessage((Component)Component.translatable((String)"ars_nouveau.warp_scroll.already_recorded"));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip2, flagIn);
        stack.addToTooltip(DataComponentRegistry.WARP_SCROLL, context, tooltip2::add, flagIn);
    }

    @Override
    public Collection<AliasProvider.Alias> getAliases() {
        return List.of(new AliasProvider.Alias("warp_portal", "Warp Portal"));
    }
}

