/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.method;

import com.hollingsworth.arsnouveau.api.particle.ParticleEmitter;
import com.hollingsworth.arsnouveau.api.particle.configurations.properties.SoundProperty;
import com.hollingsworth.arsnouveau.api.particle.timelines.IParticleTimelineType;
import com.hollingsworth.arsnouveau.api.particle.timelines.SelfTimeline;
import com.hollingsworth.arsnouveau.api.particle.timelines.TimelineEntryData;
import com.hollingsworth.arsnouveau.api.registry.ParticleTimelineRegistry;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.CastResolveType;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.lib.GlyphLib;
import java.util.Set;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MethodSelf
extends AbstractCastMethod {
    public static MethodSelf INSTANCE = new MethodSelf();

    private MethodSelf() {
        super(GlyphLib.MethodSelfID, "Self");
    }

    @Override
    public CastResolveType onCast(ItemStack stack, LivingEntity caster, Level world, SpellStats spellStats, SpellContext context, SpellResolver resolver) {
        resolver.onResolveEffect(caster.getCommandSenderWorld(), (HitResult)new EntityHitResult((Entity)caster));
        ParticleEmitter emitter = this.resolveEmitter(context, caster.getHitbox().getCenter());
        emitter.tick(world);
        this.playResolveSound(context, caster.level(), caster.getHitbox().getCenter());
        return CastResolveType.SUCCESS;
    }

    @Override
    public CastResolveType onCastOnBlock(UseOnContext context, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Level world = context.getLevel();
        resolver.onResolveEffect(world, (HitResult)new EntityHitResult((Entity)context.getPlayer()));
        ParticleEmitter emitter = this.resolveEmitter(spellContext, context.getPlayer().getHitbox().getCenter());
        emitter.tick(world);
        this.playResolveSound(spellContext, world, context.getPlayer().getHitbox().getCenter());
        return CastResolveType.SUCCESS;
    }

    @Override
    public CastResolveType onCastOnBlock(BlockHitResult blockRayTraceResult, LivingEntity caster, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Level world = caster.level;
        resolver.onResolveEffect(world, (HitResult)new EntityHitResult((Entity)caster));
        ParticleEmitter emitter = this.resolveEmitter(spellContext, caster.getHitbox().getCenter());
        emitter.tick(world);
        this.playResolveSound(spellContext, world, caster.getHitbox().getCenter());
        return CastResolveType.SUCCESS;
    }

    @Override
    public CastResolveType onCastOnEntity(ItemStack stack, LivingEntity playerIn, Entity target, InteractionHand hand, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        Level world = playerIn.level;
        resolver.onResolveEffect(world, (HitResult)new EntityHitResult((Entity)playerIn));
        ParticleEmitter emitter = this.resolveEmitter(spellContext, playerIn.getHitbox().getCenter());
        emitter.tick(world);
        this.playResolveSound(spellContext, world, target.position());
        return CastResolveType.SUCCESS;
    }

    public ParticleEmitter resolveEmitter(SpellContext spellContext, Vec3 position) {
        TimelineEntryData entryData = ((SelfTimeline)spellContext.getParticleTimeline((IParticleTimelineType)ParticleTimelineRegistry.SELF_TIMELINE.get())).onResolvingEffect;
        return this.createStaticEmitter(entryData, position);
    }

    public void playResolveSound(SpellContext spellContext, Level level, Vec3 position) {
        SoundProperty soundProperty = ((SelfTimeline)spellContext.getParticleTimeline((IParticleTimelineType)ParticleTimelineRegistry.SELF_TIMELINE.get())).resolveSound;
        soundProperty.sound.playSound(level, position.x, position.y, position.z);
    }

    @Override
    public int getDefaultManaCost() {
        return 10;
    }

    @Override
    @NotNull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[0]);
    }

    @Override
    public String getBookDescription() {
        return "A spell you start with. Applies spells on the caster.";
    }

    @Override
    public boolean defaultedStarterGlyph() {
        return true;
    }
}

