/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.common.spell.rewind;

import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.common.event.timed.IRewindable;
import com.hollingsworth.arsnouveau.common.event.timed.RewindEvent;
import com.hollingsworth.arsnouveau.common.spell.rewind.IRewindCallback;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.phys.Vec3;

public class RewindEntityData
implements IRewindCallback {
    public long gameTime;
    public Vec3 deltaMovement;
    public Vec3 position;
    public float health;

    public RewindEntityData(long gameTime, Vec3 deltaMovement, Vec3 position, float health) {
        this.gameTime = gameTime;
        this.deltaMovement = deltaMovement;
        this.position = position;
        this.health = health;
    }

    @Override
    public void onRewind(RewindEvent event) {
        LivingEntity living;
        IRewindable rewindable;
        Entity entity;
        block10: {
            block9: {
                entity = event.entity;
                if (!(entity instanceof IRewindable)) break block9;
                rewindable = (IRewindable)entity;
                if (!entity.isRemoved() && (!(entity instanceof LivingEntity) || !(living = (LivingEntity)entity).isDeadOrDying())) break block10;
            }
            return;
        }
        entity.hurtMarked = true;
        rewindable.setRewinding(false);
        if (event.respectsGravity) {
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                AttributeInstance weightless = le.getAttribute(PerkAttributes.WEIGHT);
                ResourceLocation modifierId = ArsNouveau.prefix("rewind");
                if (weightless != null) {
                    weightless.addOrUpdateTransientModifier(new AttributeModifier(modifierId, -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                }
            } else {
                entity.setNoGravity(true);
            }
        }
        entity.setPos(this.position);
        entity.setDeltaMovement(this.deltaMovement.scale(-1.0));
        entity.fallDistance = 0.0f;
        rewindable.setRewinding(true);
        if (event.serverSide && entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            living.setHealth(this.health);
        }
    }
}

