/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.facet.taxonomy;

import java.util.Arrays;
import org.apache.lucene.ars_nouveau.facet.taxonomy.AssociationFacetField;
import org.apache.lucene.ars_nouveau.util.BitUtil;
import org.apache.lucene.ars_nouveau.util.BytesRef;

public class IntAssociationFacetField
extends AssociationFacetField {
    public IntAssociationFacetField(int assoc, String dim, String ... path) {
        super(IntAssociationFacetField.intToBytesRef(assoc), dim, path);
    }

    public static BytesRef intToBytesRef(int v) {
        byte[] bytes = new byte[4];
        BitUtil.VH_BE_INT.set(bytes, 0, v);
        return new BytesRef(bytes);
    }

    public static int bytesRefToInt(BytesRef b) {
        return BitUtil.VH_BE_INT.get(b.bytes, b.offset);
    }

    @Override
    public String toString() {
        return "IntAssociationFacetField(dim=" + this.dim + " path=" + Arrays.toString(this.path) + " value=" + IntAssociationFacetField.bytesRefToInt(this.assoc) + ")";
    }
}

