/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.EquipmentAbility;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Function;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public interface CompositeAbility<ENTRY extends EquipmentAbility>
extends EquipmentAbility {
    public static <E extends EquipmentAbility, A extends CompositeAbility<E>> Codec<A> codec(Codec<E> entryCodec, Function<List<E>, A> f, Function<A, List<E>> g) {
        return entryCodec.listOf().xmap(f, g);
    }

    public static <E extends EquipmentAbility, B extends ByteBuf, A extends CompositeAbility<E>> StreamCodec<B, A> streamCodec(StreamCodec<B, E> entryCodec, Function<List<E>, A> f, Function<A, List<E>> g) {
        return ByteBufCodecs.list().apply(entryCodec).map(f, g);
    }

    public List<ENTRY> entries();

    @Override
    default public boolean isNonCosmetic() {
        for (EquipmentAbility entry : this.entries()) {
            if (!entry.isNonCosmetic()) continue;
            return true;
        }
        return false;
    }

    @Override
    default public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
        for (EquipmentAbility entry : this.entries()) {
            if (!entry.isNonCosmetic()) continue;
            entry.addToTooltip(writer);
        }
    }
}

