/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.baguettelib.mixin;

import com.leclowndu93150.baguettelib.event.inventory.InventoryUpdateEvent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerEquipmentMixin {
    @Inject(method={"setItemSlot"}, at={@At(value="HEAD")})
    private void onSetItemSlot(EquipmentSlot slot, ItemStack stack, CallbackInfo ci) {
        Player self = (Player)this;
        if (self.level().isClientSide) {
            return;
        }
        ItemStack oldStack = self.getItemBySlot(slot);
        if (ItemStack.matches((ItemStack)oldStack, (ItemStack)stack)) {
            return;
        }
        int slotIndex = PlayerEquipmentMixin.getSlotIndex(slot);
        if (slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
            NeoForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.Armor(self, slot, slotIndex, oldStack, stack));
        } else if (slot.getType() == EquipmentSlot.Type.HAND) {
            NeoForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.Hands(self, slot, slotIndex, oldStack, stack));
        }
        NeoForge.EVENT_BUS.post((Event)new InventoryUpdateEvent.All(self, slotIndex, oldStack, stack));
    }

    private static int getSlotIndex(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.MAINHAND -> 0;
            case EquipmentSlot.OFFHAND -> 40;
            case EquipmentSlot.FEET -> 36;
            case EquipmentSlot.LEGS -> 37;
            case EquipmentSlot.CHEST -> 38;
            case EquipmentSlot.HEAD -> 39;
            default -> -1;
        };
    }
}

