/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.compat;

import com.breakinblocks.beer.Config;
import com.breakinblocks.beer.compat.EnchantingTableCategory;
import com.breakinblocks.beer.recipe.BeerRecipes;
import com.breakinblocks.beer.recipe.EnchantingModifierRecipeType;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;

@JeiPlugin
public class BeerJEIPlugin
implements IModPlugin {
    private static final Logger LOGGER = LogUtils.getLogger();

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"beer", (String)"enchanting_modifiers");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new EnchantingTableCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!Config.enableItemModifiers) {
            return;
        }
        List<Object> jeiRecipes = new ArrayList();
        try {
            if (Minecraft.getInstance().level != null) {
                RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
                net.minecraft.world.item.crafting.RecipeType<EnchantingModifierRecipeType> recipeType = BeerRecipes.ENCHANTING_MODIFIER_TYPE.get();
                if (recipeManager != null && recipeType != null) {
                    List allRecipes = recipeManager.getAllRecipesFor(recipeType);
                    jeiRecipes = allRecipes.stream().sorted((r1, r2) -> r1.id().compareNamespaced(r2.id())).map(recipeHolder -> (EnchantingModifierRecipeType)recipeHolder.value()).collect(Collectors.toList());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[BEER JEI] Failed to load datapack recipes", (Throwable)e);
        }
        registration.addRecipes(EnchantingTableCategory.TYPE, jeiRecipes);
        registration.addItemStackInfo(new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE), new Component[]{Component.translatable((String)"jei.beer.enchanting_table.info.title").withStyle(ChatFormatting.GOLD), Component.translatable((String)"jei.beer.enchanting_table.info.bookshelf_range").withStyle(ChatFormatting.BLACK), Component.translatable((String)"jei.beer.enchanting_table.info.configuration").withStyle(ChatFormatting.BLACK), Component.translatable((String)"jei.beer.enchanting_table.info.range_modification").withStyle(ChatFormatting.BLACK)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.ENCHANTING_TABLE), new RecipeType[]{EnchantingTableCategory.TYPE});
    }
}

