/*
 * Decompiled with CFR 0.152.
 */
package com.breakinblocks.beer.network;

import com.breakinblocks.beer.network.ApplyItemModifierPacket;
import com.breakinblocks.beer.network.RequestEnchantingDataPacket;
import com.breakinblocks.beer.network.SyncEnchantingDataPacket;
import com.breakinblocks.beer.network.UpdateRangePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="beer")
public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("beer").versioned(PROTOCOL_VERSION);
        registrar.playToServer(UpdateRangePacket.TYPE, UpdateRangePacket.STREAM_CODEC, UpdateRangePacket::handle);
        registrar.playToServer(RequestEnchantingDataPacket.TYPE, RequestEnchantingDataPacket.STREAM_CODEC, RequestEnchantingDataPacket::handle);
        registrar.playToClient(ApplyItemModifierPacket.TYPE, ApplyItemModifierPacket.STREAM_CODEC, ApplyItemModifierPacket::handle);
        registrar.playToClient(SyncEnchantingDataPacket.TYPE, SyncEnchantingDataPacket.STREAM_CODEC, SyncEnchantingDataPacket::handle);
    }

    public static void sendToServer(CustomPacketPayload packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayer(CustomPacketPayload packet, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToAllPlayers(CustomPacketPayload packet) {
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToPlayersNear(CustomPacketPayload packet, ServerLevel level, BlockPos pos, double range) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)range, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

