/*
 * Decompiled with CFR 0.152.
 */
package rearth.belts.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Tuple;
import net.minecraft.world.phys.Vec3;
import rearth.belts.blocks.ChuteBlockEntity;

public class SplineUtil {
    public static Vec3 getPositionOnSpline(ChuteBlockEntity.BeltData data, double t) {
        return SplineUtil.getPositionOnSpline(data.allPoints(), data.totalLength(), data.segmentLengths(), t);
    }

    public static Vec3 getPositionOnSpline(Vec3 start, Vec3 startDir, Vec3 end, Vec3 endDir, List<Tuple<BlockPos, Direction>> middlePoints, double t) {
        List<Tuple<Vec3, Vec3>> transformedMidPoints = middlePoints.stream().map(elem -> new Tuple((Object)((BlockPos)elem.getA()).getCenter(), (Object)Vec3.atLowerCornerOf((Vec3i)((Direction)elem.getB()).getNormal()))).toList();
        List<Tuple<Vec3, Vec3>> allPairs = SplineUtil.getPointPairs(start, startDir, end, endDir, transformedMidPoints);
        Double[] segmentLengths = new Double[allPairs.size() - 1];
        double totalLength = 0.0;
        for (int i = 0; i < allPairs.size() - 1; ++i) {
            Tuple<Vec3, Vec3> from = allPairs.get(i);
            Tuple<Vec3, Vec3> to = allPairs.get(i + 1);
            double length = SplineUtil.getLineLength((Vec3)from.getA(), (Vec3)from.getB(), (Vec3)to.getA(), ((Vec3)to.getB()).scale(1.0));
            segmentLengths[i] = length;
            totalLength += length;
        }
        return SplineUtil.getPositionOnSpline(allPairs, totalLength, segmentLengths, t);
    }

    public static Vec3 getPositionOnSpline(List<Tuple<Vec3, Vec3>> allPoints, double totalLength, Double[] segmentLengths, double t) {
        t = Math.clamp(t, 0.0, 1.0);
        double targetLength = totalLength * t;
        double traversedLength = 0.0;
        for (int i = 0; i < allPoints.size() - 1; ++i) {
            Double segmentLength = segmentLengths[i];
            if (targetLength >= traversedLength && targetLength < traversedLength + segmentLength) {
                Tuple<Vec3, Vec3> from = allPoints.get(i);
                Tuple<Vec3, Vec3> to = allPoints.get(i + 1);
                double offset = targetLength - traversedLength;
                double delta = offset / segmentLength;
                double mappedT = SplineUtil.remapProgress(delta);
                return SplineUtil.getPointOnHermiteSpline((Vec3)from.getA(), ((Vec3)from.getB()).scale(segmentLength * 1.5), (Vec3)to.getA(), ((Vec3)to.getB()).scale(segmentLength * 1.5), mappedT);
            }
            traversedLength += segmentLength.doubleValue();
        }
        return (Vec3)allPoints.getLast().getA();
    }

    private static double remapProgress(double x) {
        return 0.4791667 * x + 1.5625 * (x * x) - 1.041667 * (x * x * x);
    }

    public static double getLineLength(Vec3 from, Vec3 fromTangent, Vec3 to, Vec3 toTangent) {
        double approxLength = from.distanceTo(to);
        if (fromTangent.distanceToSqr(toTangent) < 0.1) {
            approxLength += 1.0;
        }
        Vec3 midPointA = SplineUtil.getPointOnHermiteSpline(from, fromTangent.scale(approxLength), to, toTangent.scale(approxLength), 0.33f);
        Vec3 midPointB = SplineUtil.getPointOnHermiteSpline(from, fromTangent.scale(approxLength), to, toTangent.scale(approxLength), 0.66f);
        return from.distanceTo(midPointA) + midPointA.distanceTo(midPointB) + midPointB.distanceTo(to);
    }

    public static double getTotalLength(List<Tuple<Vec3, Vec3>> points) {
        double res = 0.0;
        for (int i = 0; i < points.size() - 1; ++i) {
            Tuple<Vec3, Vec3> current = points.get(i);
            Tuple<Vec3, Vec3> next = points.get(i + 1);
            double segmentLength = SplineUtil.getLineLength((Vec3)current.getA(), (Vec3)current.getB(), (Vec3)next.getA(), (Vec3)next.getB());
            res += segmentLength;
        }
        return res;
    }

    public static List<Tuple<Vec3, Vec3>> getPointPairs(Vec3 start, Vec3 startDir, Vec3 end, Vec3 endDir, List<Tuple<Vec3, Vec3>> middlePoints) {
        ArrayList<Object> pendingPoints = new ArrayList<Object>();
        pendingPoints.addAll(middlePoints);
        pendingPoints.add(new Tuple((Object)end, (Object)endDir));
        ArrayList<Tuple<Vec3, Vec3>> pointsWithTangents = new ArrayList<Tuple<Vec3, Vec3>>();
        pointsWithTangents.add(new Tuple((Object)start, (Object)startDir));
        Vec3 currentFrom = start.add(startDir.scale((double)0.3f));
        while (!pendingPoints.isEmpty()) {
            double distB;
            Tuple pair = (Tuple)pendingPoints.removeFirst();
            if (((Vec3)pair.getA()).equals((Object)end)) {
                pointsWithTangents.add((Tuple<Vec3, Vec3>)new Tuple((Object)end, (Object)endDir));
                break;
            }
            Vec3 currentTo = (Vec3)pair.getA();
            double distA = currentFrom.distanceTo(((Vec3)pair.getA()).add((Vec3)pair.getB()));
            Vec3 currentToDir = distA > (distB = currentFrom.distanceTo(((Vec3)pair.getA()).subtract((Vec3)pair.getB()))) ? (Vec3)pair.getB() : ((Vec3)pair.getB()).scale(-1.0);
            currentFrom = currentTo.add(currentToDir.scale((double)-0.3f));
            pointsWithTangents.add((Tuple<Vec3, Vec3>)new Tuple((Object)currentTo, (Object)currentToDir));
        }
        return pointsWithTangents;
    }

    public static Vec3 getPointOnHermiteSpline(Vec3 pointA, Vec3 tangentA, Vec3 pointB, Vec3 tangentB, double t) {
        if (t < 0.0) {
            t = 0.0;
        }
        if (t > 1.0) {
            t = 1.0;
        }
        double t2 = t * t;
        double t3 = t2 * t;
        double h00 = 2.0 * t3 - 3.0 * t2 + 1.0;
        double h10 = t3 - 2.0 * t2 + t;
        double h01 = -2.0 * t3 + 3.0 * t2;
        double h11 = t3 - t2;
        Vec3 termP0 = pointA.scale(h00);
        Vec3 termM0 = tangentA.scale(h10);
        Vec3 termP1 = pointB.scale(h01);
        Vec3 termM1 = tangentB.scale(h11);
        return termP0.add(termM0).add(termP1).add(termM1);
    }
}

