/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.ricmc.betterblockz.block.ModBlocks;

public class BlockInteractEvents {
    private BlockInteractEvents() {
    }

    public static boolean isFromOurMod(Item item) {
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)item);
        return key != null && "betterblockz".equals(key.getNamespace());
    }

    public static boolean cycleVariant(Player player, InteractionHand hand, boolean forward) {
        ItemStack stack = player.getItemInHand(hand);
        if (!(stack.getItem() instanceof BlockItem)) {
            return false;
        }
        if (!BlockInteractEvents.isFromOurMod(stack.getItem())) {
            return false;
        }
        List<Object> variants = null;
        List<Object> cyberThin = ModBlocks.CYBERLIGHT_THIN.stream().map(def -> ((Block)def.get()).asItem()).toList();
        List<Item> cyberThinAlt = ModBlocks.CYBERLIGHT_THIN_ALT.stream().map(def -> ((Block)def.get()).asItem()).toList();
        List<Item> cyberBar = ModBlocks.CYBERLIGHT_BAR.stream().map(def -> ((Block)def.get()).asItem()).toList();
        List<Item> cyberBarVertical = ModBlocks.CYBERLIGHT_BAR_VERTICAL.stream().map(def -> ((Block)def.get()).asItem()).toList();
        variants = cyberThin.contains(stack.getItem()) ? cyberThin : (cyberThinAlt.contains(stack.getItem()) ? cyberThinAlt : (cyberBar.contains(stack.getItem()) ? cyberBar : (cyberBarVertical.contains(stack.getItem()) ? cyberBarVertical : (List<Object>)Arrays.stream(ModBlocks.VARIANTS.values().toArray(new Object[0])).map(arr -> {
            try {
                return Arrays.stream((Object[])arr).map(def -> ((Block)((DeferredBlock)def).get()).asItem()).toList();
            }
            catch (ClassCastException e) {
                return List.of();
            }
        }).filter(list -> list.contains(stack.getItem())).findFirst().orElse(null))));
        if (variants == null || variants.isEmpty()) {
            return false;
        }
        int currentIndex = variants.indexOf(stack.getItem());
        int nextIndex = forward ? (currentIndex + 1) % variants.size() : (currentIndex - 1 + variants.size()) % variants.size();
        Item nextItem = variants.get(nextIndex);
        ItemStack newStack = new ItemStack((ItemLike)nextItem, stack.getCount());
        player.setItemInHand(hand, newStack);
        return true;
    }

    public static void setVariant(ServerPlayer player, InteractionHand hand, int targetIndex) {
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (!BlockInteractEvents.isFromOurMod((Item)blockItem)) {
            return;
        }
        Block heldBlock = blockItem.getBlock();
        for (DeferredBlock<?>[] value : ModBlocks.VARIANTS.values()) {
            try {
                DeferredBlock<?>[] arr;
                for (DeferredBlock<?> deferredBlock : arr = value) {
                    if (deferredBlock.get() != heldBlock || targetIndex < 0 || targetIndex >= arr.length) continue;
                    Block newBlock = (Block)arr[targetIndex].get();
                    BlockInteractEvents.swapItem(player, hand, stack, newBlock);
                    return;
                }
            }
            catch (ClassCastException arr) {
            }
        }
        List<DeferredBlock<Block>> cyberThin = ModBlocks.CYBERLIGHT_THIN;
        List<DeferredBlock<Block>> cyberThinAlt = ModBlocks.CYBERLIGHT_THIN_ALT;
        List<DeferredBlock<Block>> cyberBar = ModBlocks.CYBERLIGHT_BAR;
        List<DeferredBlock<Block>> cyberBarVertical = ModBlocks.CYBERLIGHT_BAR_VERTICAL;
        if (cyberThin.stream().anyMatch(def -> def.get() == heldBlock)) {
            if (targetIndex >= 0 && targetIndex < cyberThin.size()) {
                BlockInteractEvents.swapItem(player, hand, stack, (Block)cyberThin.get(targetIndex).get());
            }
        } else if (cyberThinAlt.stream().anyMatch(def -> def.get() == heldBlock)) {
            if (targetIndex >= 0 && targetIndex < cyberThinAlt.size()) {
                BlockInteractEvents.swapItem(player, hand, stack, (Block)cyberThinAlt.get(targetIndex).get());
            }
        } else if (cyberBar.stream().anyMatch(def -> def.get() == heldBlock)) {
            if (targetIndex >= 0 && targetIndex < cyberBar.size()) {
                BlockInteractEvents.swapItem(player, hand, stack, (Block)cyberBar.get(targetIndex).get());
            }
        } else if (cyberBarVertical.stream().anyMatch(def -> def.get() == heldBlock) && targetIndex >= 0 && targetIndex < cyberBarVertical.size()) {
            BlockInteractEvents.swapItem(player, hand, stack, (Block)cyberBarVertical.get(targetIndex).get());
        }
    }

    private static void swapItem(ServerPlayer player, InteractionHand hand, ItemStack oldStack, Block newBlock) {
        ItemStack newStack = new ItemStack((ItemLike)newBlock, oldStack.getCount());
        DataComponentMap components = oldStack.getComponents();
        if (!components.isEmpty()) {
            newStack.applyComponents(components);
        }
        player.setItemInHand(hand, newStack);
        player.containerMenu.broadcastChanges();
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        boolean forward = player.isShiftKeyDown();
        boolean backward = player.isSprinting();
        if ((forward || backward) && BlockInteractEvents.cycleVariant(player, event.getHand(), forward)) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }
}

