/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.item.custom;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BlockDisconnectItem
extends Item {
    public BlockDisconnectItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        for (Property prop : state.getProperties()) {
            String message;
            if (!(prop instanceof BooleanProperty)) continue;
            BooleanProperty litProp = (BooleanProperty)prop;
            if (!prop.getName().equals("lit")) continue;
            boolean lit = (Boolean)state.getValue((Property)litProp);
            level.setBlock(pos, (BlockState)state.setValue((Property)litProp, (Comparable)Boolean.valueOf(!lit)), 3);
            String string = message = lit ? "Disconnected" : "Connected";
            if (context.getPlayer() != null) {
                context.getPlayer().displayClientMessage((Component)Component.literal((String)message), true);
            }
            level.playSound(null, pos, (SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), SoundSource.BLOCKS, 1.0f, 1.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void appendHoverText(ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        String baseKey = stack.getItem().getDescriptionId();
        if (Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".shift.line1")));
        } else {
            tooltip.add((Component)Component.translatable((String)(baseKey + ".tooltip")));
        }
        super.appendHoverText(stack, context, tooltip, flag);
    }
}

