/*
 * Decompiled with CFR 0.152.
 */
package net.ricmc.betterblockz.network;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.ricmc.betterblockz.BlockInteractEvents;
import net.ricmc.betterblockz.network.payload.BlockZResetPayload;
import net.ricmc.betterblockz.network.payload.BlockZScrollPayload;
import net.ricmc.betterblockz.network.payload.BlockZSetVariantPayload;
import net.ricmc.betterblockz.network.payload.BlockZSwitchPayload;

@EventBusSubscriber(modid="betterblockz")
public class ModPayloads {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        event.registrar("betterblockz:blockz_switch").playToServer(BlockZSwitchPayload.TYPE, BlockZSwitchPayload.STREAM_CODEC, ModPayloads::handleBlockZSwitch);
        event.registrar("betterblockz:blockz_scroll").playToServer(BlockZScrollPayload.TYPE, BlockZScrollPayload.STREAM_CODEC, ModPayloads::handleBlockZScroll);
        event.registrar("betterblockz:blockz_reset").playToServer(BlockZResetPayload.TYPE, BlockZResetPayload.STREAM_CODEC, ModPayloads::handleBlockZReset);
        event.registrar("betterblockz:blockz_set_variant").playToServer(BlockZSetVariantPayload.TYPE, BlockZSetVariantPayload.STREAM_CODEC, ModPayloads::handleBlockZSetVariant);
    }

    private static void handleBlockZSwitch(BlockZSwitchPayload payload, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            context.enqueueWork(() -> {});
        }
    }

    private static void handleBlockZScroll(BlockZScrollPayload payload, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            context.enqueueWork(() -> BlockInteractEvents.cycleVariant((Player)player2, InteractionHand.MAIN_HAND, payload.forward()));
        }
    }

    private static void handleBlockZReset(BlockZResetPayload payload, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            context.enqueueWork(() -> BlockInteractEvents.setVariant(player2, InteractionHand.MAIN_HAND, 0));
        }
    }

    private static void handleBlockZSetVariant(BlockZSetVariantPayload payload, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            context.enqueueWork(() -> BlockInteractEvents.setVariant(player2, InteractionHand.MAIN_HAND, payload.index()));
        }
    }

    public static void sendBlockZSwitch() {
        PacketDistributor.sendToServer((CustomPacketPayload)new BlockZSwitchPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendBlockZScroll(boolean forward) {
        PacketDistributor.sendToServer((CustomPacketPayload)new BlockZScrollPayload(forward), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendBlockZResetVariant() {
        PacketDistributor.sendToServer((CustomPacketPayload)new BlockZResetPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendSetVariant(int index) {
        PacketDistributor.sendToServer((CustomPacketPayload)new BlockZSetVariantPayload(index), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

