/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.compatibility.patchouli;

import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockFakeLevel;
import com.davenonymous.bonsaitrees.client.multiblock.MultiBlockModel;
import com.davenonymous.bonsaitrees.setup.ModModelLoaders;
import com.davenonymous.bonsaitrees.setup.cache.BonsaiCache;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.UnaryOperator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.lwjgl.opengl.GL11;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class TreeRenderComponent
implements ICustomComponent {
    private transient int x;
    private transient int y;
    private transient ItemStack sapling;
    private transient MultiBlockModel treeModel;
    public IVariable item;
    public float scale = 100.0f;

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX;
        this.y = componentY;
    }

    public void render(GuiGraphics guiGraphics, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        ResourceLocation modelId = BonsaiCache.BONSAI_BY_ITEM.get(this.sapling.getItem()).model();
        ModelResourceLocation treeModelId = ModModelLoaders.MODEL_MAP.get(modelId);
        MultiBlockModel multiBlockModel = (MultiBlockModel)Minecraft.getInstance().getModelManager().getModel(treeModelId);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.x + 50), (float)(this.y + 100), 100.0f);
        guiGraphics.pose().scale(this.scale, this.scale, this.scale);
        guiGraphics.pose().mulPose(new Quaternionf(new AxisAngle4f((float)Math.toRadians(155.0), 1.0f, 0.0f, 0.0f)));
        int rotationDurationTicks = 300;
        long worldTicks = Minecraft.getInstance().level.getGameTime();
        int smallWorldTicks = (int)(worldTicks % (long)rotationDurationTicks);
        double progressTicks = (float)smallWorldTicks + pticks;
        double percent = progressTicks / (double)rotationDurationTicks;
        guiGraphics.pose().mulPose(new Quaternionf(new AxisAngle4f((float)Math.toRadians(percent * 360.0), 0.0f, 1.0f, 0.0f)));
        MultiBlockFakeLevel fakeLevel = new MultiBlockFakeLevel(multiBlockModel, (BlockAndTintGetter)Minecraft.getInstance().level, BlockPos.ZERO);
        VertexBuffer treeVbo = ModModelLoaders.getVbo(modelId, multiBlockModel, fakeLevel, BlockPos.ZERO);
        if (treeVbo != null && !treeVbo.isInvalid()) {
            Matrix4f viewMatrix = new Matrix4f((Matrix4fc)RenderSystem.getModelViewMatrix());
            Matrix4f projectionMatrix = RenderSystem.getProjectionMatrix();
            viewMatrix.mul((Matrix4fc)guiGraphics.pose().last().pose());
            ModModelLoaders.renderTypeForModels.setupRenderState();
            ShaderInstance shader = RenderSystem.getShader();
            shader.setDefaultUniforms(VertexFormat.Mode.QUADS, viewMatrix, projectionMatrix, Minecraft.getInstance().getWindow());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setupShaderLights((ShaderInstance)shader);
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
            RenderSystem.depthMask((boolean)true);
            treeVbo.bind();
            GL11.glFrontFace((int)2304);
            treeVbo.drawWithShader(viewMatrix, projectionMatrix, shader);
            GL11.glFrontFace((int)2305);
            VertexBuffer.unbind();
        }
        guiGraphics.pose().popPose();
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup, HolderLookup.Provider registries) {
        this.sapling = (ItemStack)((IVariable)lookup.apply(this.item)).as(ItemStack.class);
    }
}

