/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.datagen;

import com.davenonymous.bonsaitrees.datagen.DGBlockLoot;
import com.davenonymous.bonsaitrees.datagen.DGBlockStates;
import com.davenonymous.bonsaitrees.datagen.DGBlockTags;
import com.davenonymous.bonsaitrees.datagen.DGRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="bonsaitrees4")
public class DGHandler {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        DGBlockTags blockTagsProvider = new DGBlockTags(output, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeClient(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new DGBlockStates(output, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new DGRecipes(output, lookupProvider));
        ArrayList<LootTableProvider.SubProviderEntry> lootTableSources = new ArrayList<LootTableProvider.SubProviderEntry>();
        lootTableSources.add(new LootTableProvider.SubProviderEntry(DGBlockLoot::new, LootContextParamSets.BLOCK));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), lootTableSources, lookupProvider));
    }
}

