/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees.setup.cache;

import com.davenonymous.bonsaitrees.setup.ModDataMaps;
import com.davenonymous.bonsaitrees.setup.data.BonsaiInfo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.datamaps.DataMapsUpdatedEvent;

public class BonsaiCache {
    public static final Map<Item, BonsaiInfo> BONSAI_BY_ITEM = new HashMap<Item, BonsaiInfo>();
    public static final Map<ResourceLocation, BonsaiInfo> BONSAI_BY_RESOURCE = new HashMap<ResourceLocation, BonsaiInfo>();

    public static void dataMapsUpdated(DataMapsUpdatedEvent event) {
        event.ifRegistry(Registries.ITEM, itemRegistry -> {
            BONSAI_BY_ITEM.clear();
            BONSAI_BY_RESOURCE.clear();
            Map data = itemRegistry.getDataMap(ModDataMaps.BONSAI);
            for (Map.Entry entry : data.entrySet()) {
                ResourceKey itemKey = (ResourceKey)entry.getKey();
                BonsaiInfo bonsai = (BonsaiInfo)entry.getValue();
                Item item = (Item)itemRegistry.get(itemKey);
                BONSAI_BY_ITEM.put(item, bonsai);
                BONSAI_BY_RESOURCE.put(itemKey.location(), bonsai);
            }
        });
    }
}

