/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.api.util;

import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public interface IGameplayHelper {
    public static final RandomSource RNG = RandomSource.create();

    default public ItemStack getCraftingRemainder(ItemStack input) {
        Item remainder;
        if (input.getItem().hasCraftingRemainingItem() && (remainder = input.getItem().getCraftingRemainingItem()) != null) {
            return remainder.getDefaultInstance();
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack inventoryInsert(ServerLevel level, BlockPos pos, Direction side, ItemStack stack) {
        if (stack.isEmpty()) {
            return stack;
        }
        Container container = this.getContainer(level, pos);
        return container != null ? HopperBlockEntity.addItem(null, (Container)container, (ItemStack)stack, (Direction)side) : stack;
    }

    @Nullable
    default public Container getContainer(ServerLevel level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder holder = (WorldlyContainerHolder)block;
            return holder.getContainer(state, (LevelAccessor)level, pos);
        }
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof Container) {
            Container beContainer = (Container)be;
            return beContainer;
        }
        return null;
    }

    default public ItemStack addItem(ItemStack stack, NonNullList<ItemStack> inventory, int[] slots) {
        for (int slot : slots) {
            if (stack.isEmpty()) {
                return stack;
            }
            ItemStack existing = (ItemStack)inventory.get(slot);
            if (existing.isEmpty()) {
                inventory.set(slot, (Object)stack);
                return ItemStack.EMPTY;
            }
            if (existing.getCount() >= existing.getMaxStackSize() || !ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)stack)) continue;
            int availableSpace = existing.getMaxStackSize() - existing.getCount();
            int movedAmount = Math.min(stack.getCount(), availableSpace);
            stack.shrink(movedAmount);
            existing.grow(movedAmount);
        }
        return stack;
    }

    public <T extends BlockEntity> BlockEntityType.Builder<T> blockEntityBuilder(BiFunction<BlockPos, BlockState, T> var1, Block ... var2);

    default public void dropRemainders(Level level, BlockPos pos, ItemStack old) {
        ItemStack remainder;
        if (!(level.isClientSide || old.isEmpty() || (remainder = this.getCraftingRemainder(old)).isEmpty())) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)remainder.copy());
        }
    }

    public CreativeModeTab.Builder tabBuilder();
}

