/*
 * Decompiled with CFR 0.152.
 */
package com.portingdeadmods.cable_facades.events;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.portingdeadmods.cable_facades.CFConfig;
import com.portingdeadmods.cable_facades.CFMain;
import com.portingdeadmods.cable_facades.compat.iris.AlphaWrapperIris;
import com.portingdeadmods.cable_facades.mixins.LevelRendererAccess;
import com.portingdeadmods.cable_facades.registries.CFRenderTypes;
import com.portingdeadmods.cable_facades.utils.ClientFacadeManager;
import com.portingdeadmods.cable_facades.utils.FacadeUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddSectionGeometryEvent;
import net.neoforged.neoforge.client.event.RenderHighlightEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.pipeline.VertexConsumerWrapper;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="cable_facades", value={Dist.CLIENT})
public final class GameClientEvents {
    public static final ThreadLocal<Boolean> RENDERING_FACADE = ThreadLocal.withInitial(() -> false);
    public static boolean facadeTransparency = false;
    public static boolean setFacadeTransparency = false;
    private static final ThreadLocal<RandomSource> RANDOM = ThreadLocal.withInitial(RandomSource::create);
    private static Timer resetTimer;

    @SubscribeEvent
    public static void render(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        if (setFacadeTransparency != facadeTransparency) {
            setFacadeTransparency = facadeTransparency;
            ObjectOpenHashSet sections = new ObjectOpenHashSet();
            ClientFacadeManager.FACADED_BLOCKS.keySet().forEach(arg_0 -> GameClientEvents.lambda$render$1((Set)sections, arg_0));
            for (SectionPos section : sections) {
                Minecraft.getInstance().levelRenderer.setSectionDirty(section.x(), section.y(), section.z());
            }
            if (facadeTransparency) {
                if (resetTimer != null) {
                    resetTimer.cancel();
                }
                resetTimer = new Timer("Cable Facades Reset Timer");
                resetTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        CFMain.LOGGER.info("Facades made opaque due to timeout");
                        facadeTransparency = false;
                    }
                }, 120000L);
            } else {
                resetTimer.cancel();
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @SubscribeEvent
    public static void geometryEvent(AddSectionGeometryEvent e) {
        SectionPos section = SectionPos.of((BlockPos)e.getSectionOrigin());
        if (ClientFacadeManager.FACADED_BLOCKS.isEmpty()) {
            return;
        }
        @Nullable Object2ObjectOpenHashMap actualBlocks = new Object2ObjectOpenHashMap();
        ClientFacadeManager.FACADED_BLOCKS.entrySet().stream().filter(p -> SectionPos.of((BlockPos)((BlockPos)p.getKey())).equals((Object)section)).forEachOrdered(arg_0 -> GameClientEvents.lambda$geometryEvent$3((Map)actualBlocks, arg_0));
        if (actualBlocks.isEmpty()) {
            return;
        }
        e.addRenderer(arg_0 -> GameClientEvents.lambda$geometryEvent$4((Map)actualBlocks, arg_0));
    }

    @SubscribeEvent
    public static void renderOutline(RenderHighlightEvent.Block event) {
        Entity entity = event.getCamera().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            Level world = living.level();
            BlockHitResult rtr = event.getTarget();
            BlockPos pos = rtr.getBlockPos();
            Vec3 renderView = event.getCamera().getPosition();
            BlockState targetBlock = world.getBlockState(rtr.getBlockPos());
            if (FacadeUtils.hasFacade((BlockGetter)world, pos)) {
                ((LevelRendererAccess)event.getLevelRenderer()).callRenderHitOutline(event.getPoseStack(), event.getMultiBufferSource().getBuffer(CFRenderTypes.LINES_NONTRANSLUCENT), (Entity)living, renderView.x, renderView.y, renderView.z, pos, targetBlock);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ClientFacadeManager.FACADED_BLOCKS.clear();
    }

    private static /* synthetic */ void lambda$geometryEvent$4(Map actualBlocks, AddSectionGeometryEvent.SectionRenderingContext sectionRenderingContext) {
        RENDERING_FACADE.set(true);
        BlockAndTintGetter level = sectionRenderingContext.getRegion();
        RandomSource random = RANDOM.get();
        for (Map.Entry blockPosBlockStateEntry : actualBlocks.entrySet()) {
            random.setSeed(42L);
            BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
            BlockState facadeState = (BlockState)blockPosBlockStateEntry.getValue();
            BlockPos pos = (BlockPos)blockPosBlockStateEntry.getKey();
            PoseStack poseStack = sectionRenderingContext.getPoseStack();
            BakedModel facadeModel = blockRenderer.getBlockModel(facadeState);
            ModelData modelData = facadeModel.getModelData(level, pos, facadeState, ModelData.EMPTY);
            poseStack.pushPose();
            poseStack.translate((float)SectionPos.sectionRelative((int)pos.getX()), (float)SectionPos.sectionRelative((int)pos.getY()), (float)SectionPos.sectionRelative((int)pos.getZ()));
            Block facadedBlock = level.getBlockState(pos).getBlock();
            if (CFConfig.canPatchZFighting(facadedBlock)) {
                poseStack.translate(0.5, 0.5, 0.5);
                poseStack.scale(0.99995f, 0.99995f, 0.99995f);
                poseStack.translate(-0.5, -0.5, -0.5);
            }
            if (facadedBlock.asItem().getDescriptionId().contains("create")) {
                poseStack.translate(0.5, 0.5, 0.5);
                poseStack.scale(1.0005f, 1.0005f, 1.0005f);
                poseStack.translate(-0.5, -0.5, -0.5);
            }
            for (RenderType renderType : facadeModel.getRenderTypes(facadeState, random, ModelData.EMPTY)) {
                VertexConsumer buffer = sectionRenderingContext.getOrCreateChunkBuffer(facadeTransparency ? RenderType.translucent() : renderType);
                if (facadeTransparency) {
                    buffer = CFMain.isIrisLoaded() ? new AlphaWrapperIris(buffer) : new AlphaWrapper(buffer);
                }
                blockRenderer.renderBatched(facadeState, pos, level, poseStack, buffer, true, random, modelData, renderType);
            }
            poseStack.popPose();
        }
        RENDERING_FACADE.set(false);
    }

    private static /* synthetic */ void lambda$geometryEvent$3(Map actualBlocks, Map.Entry bp) {
        if (bp.getValue() != null) {
            actualBlocks.put((BlockPos)bp.getKey(), (BlockState)bp.getValue());
        }
    }

    private static /* synthetic */ void lambda$render$1(Set sections, BlockPos k) {
        sections.add(SectionPos.of((BlockPos)k));
    }

    private static class AlphaWrapper
    extends VertexConsumerWrapper {
        public AlphaWrapper(VertexConsumer consumer) {
            super(consumer);
        }

        public VertexConsumer setColor(int color) {
            super.setColor(color & 0x88FFFFFF);
            return this;
        }
    }
}

