/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.neoforge.storage.diskinterface;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.math.Transformation;
import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.support.AbstractActiveColoredDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.neoforge.storage.DiskContainerItemOverrides;
import com.refinedmods.refinedstorage.neoforge.support.render.DiskModelBaker;
import com.refinedmods.refinedstorage.neoforge.support.render.RotationTranslationModelBaker;
import com.refinedmods.refinedstorage.neoforge.support.render.TransformationBuilder;
import com.ultramega.cabletiers.common.storage.diskinterface.TieredDiskInterfaceBlock;
import com.ultramega.cabletiers.neoforge.storage.diskinterface.ForgeTieredDiskInterfaceBlockEntity;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.BakedModelWrapper;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Vector3f;

public class TieredDiskInterfaceBakedModel
extends BakedModelWrapper<BakedModel> {
    private final LoadingCache<CacheKey, List<BakedQuad>> cache;
    private final DiskContainerItemOverrides<CacheKey> itemOverrides;
    private final Vector3f[] diskTranslations = new Vector3f[6];

    TieredDiskInterfaceBakedModel(BakedModel baseModel, RotationTranslationModelBaker inactiveBaseModelBaker, RotationTranslationModelBaker baseModelBaker, DiskModelBaker diskModelBaker, RotationTranslationModelBaker ledInactiveModelBaker) {
        super(baseModel);
        for (int i = 0; i < 6; ++i) {
            this.diskTranslations[i] = TieredDiskInterfaceBakedModel.getDiskTranslation(i);
        }
        this.cache = CacheBuilder.newBuilder().build(CacheLoader.from(cacheKey -> {
            Transformation rotation = TransformationBuilder.create().rotate(cacheKey.direction).build();
            RandomSource rand = RandomSource.create();
            List quads = (cacheKey.active ? baseModelBaker : inactiveBaseModelBaker).bake(rotation, cacheKey.side, rand);
            for (int j = 0; j < this.diskTranslations.length; ++j) {
                Disk disk = cacheKey.disks[j];
                quads.addAll(this.getDiskQuads(diskModelBaker, (CacheKey)cacheKey, disk, j));
                if (!cacheKey.withInactiveLed || disk.state() != StorageState.INACTIVE) continue;
                Transformation ledTransform = TransformationBuilder.create().rotate(cacheKey.direction).translate(this.diskTranslations[j]).build();
                quads.addAll(ledInactiveModelBaker.bake(ledTransform, cacheKey.side, rand));
            }
            return quads;
        }));
        this.itemOverrides = new DiskContainerItemOverrides(this.cache, baseModel, this.diskTranslations, disks -> new CacheKey(null, true, true, BiDirection.NORTH, (Disk[])disks), CacheKey::withSide);
    }

    public ItemOverrides getOverrides() {
        return this.itemOverrides;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        Block block;
        if (state == null || !((block = state.getBlock()) instanceof TieredDiskInterfaceBlock)) {
            return super.getQuads(state, side, rand);
        }
        TieredDiskInterfaceBlock diskInterfaceBlock = (TieredDiskInterfaceBlock)block;
        BiDirection direction = (BiDirection)diskInterfaceBlock.getDirection(state);
        if (direction == null) {
            return super.getQuads(state, side, rand);
        }
        Disk[] disks = (Disk[])extraData.get(ForgeTieredDiskInterfaceBlockEntity.DISKS_PROPERTY);
        if (disks == null) {
            return super.getQuads(state, side, rand);
        }
        boolean active = (Boolean)state.getValue((Property)AbstractActiveColoredDirectionalBlock.ACTIVE);
        return (List)this.cache.getUnchecked((Object)new CacheKey(side, active, false, direction, disks));
    }

    private List<BakedQuad> getDiskQuads(DiskModelBaker diskBakers, CacheKey cacheKey, Disk disk, int index) {
        if (disk.state() == StorageState.NONE || disk.item() == null) {
            return Collections.emptyList();
        }
        RotationTranslationModelBaker diskBaker = diskBakers.forDisk(disk.item());
        if (diskBaker == null) {
            return Collections.emptyList();
        }
        Transformation diskTransform = TransformationBuilder.create().rotate(cacheKey.direction).translate(this.diskTranslations[index]).build();
        return diskBaker.bake(diskTransform, cacheKey.side, RandomSource.create());
    }

    private static Vector3f getDiskTranslation(int i) {
        boolean x = i >= 3;
        int y = i % 3;
        return new Vector3f(!x ? -0.125f : -0.5625f, -((float)y * 3.0f / 16.0f) - 0.375f, 0.0f);
    }

    private record CacheKey(@Nullable Direction side, boolean active, boolean withInactiveLed, BiDirection direction, Disk[] disks) {
        CacheKey withSide(Direction newSide) {
            return new CacheKey(newSide, this.active, this.withInactiveLed, this.direction, this.disks);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.side == cacheKey.side && this.direction == cacheKey.direction && Arrays.equals(this.disks, cacheKey.disks) && this.withInactiveLed == cacheKey.withInactiveLed && this.active == cacheKey.active;
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(this.side, this.active, this.direction, this.withInactiveLed);
            result = 31 * result + Arrays.hashCode(this.disks);
            return result;
        }

        @Override
        public String toString() {
            return "CacheKey{side=" + String.valueOf(this.side) + ", active=" + this.active + ", withInactiveLed=" + this.withInactiveLed + ", direction=" + String.valueOf(this.direction) + ", disks=" + Arrays.toString(this.disks) + "}";
        }
    }
}

