/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.vbo;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import java.nio.ByteBuffer;
import net.minecraft.Util;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.opengl.GLCapabilities;

public class DirectBuffers {
    public static final boolean HAS_DSA;
    static final boolean ON_LINUX;

    public static int createBuffer() {
        return HAS_DSA ? GL45C.glCreateBuffers() : GL15C.glGenBuffers();
    }

    public static void deleteBuffer(int type, int id) {
        RenderSystem.assertOnRenderThread();
        if (ON_LINUX) {
            DirectBuffers.setEmptyBufferData(type, id, 35048);
        }
        GL15C.glDeleteBuffers((int)id);
    }

    public static void setBufferData(int type, int id, ByteBuffer buffer, int flags) {
        if (HAS_DSA) {
            GL45C.glNamedBufferData((int)id, (ByteBuffer)buffer, (int)flags);
        } else {
            if (type == 34962) {
                BufferUploader.reset();
            }
            GlStateManager._glBindBuffer((int)type, (int)id);
            GlStateManager._glBufferData((int)type, (ByteBuffer)buffer, (int)flags);
            GlStateManager._glBindBuffer((int)type, (int)0);
        }
    }

    public static void setEmptyBufferData(int type, int id, int flags) {
        if (HAS_DSA) {
            GL45C.glNamedBufferData((int)id, (long)0L, (int)flags);
        } else {
            if (type == 34962) {
                BufferUploader.reset();
            }
            GlStateManager._glBindBuffer((int)type, (int)id);
            GlStateManager._glBufferData((int)type, (long)0L, (int)flags);
            GlStateManager._glBindBuffer((int)type, (int)0);
        }
    }

    static {
        ON_LINUX = Util.getPlatform() == Util.OS.LINUX;
        GLCapabilities capabilities = GL.getCapabilities();
        HAS_DSA = capabilities.OpenGL45 || capabilities.GL_ARB_direct_state_access;
    }
}

