/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.blocks;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.blocks.AbstractComputerBlockEntity;
import dan200.computercraft.shared.computer.blocks.ComputerBlock;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.computer.core.TerminalSize;
import dan200.computercraft.shared.computer.inventory.AbstractComputerMenu;
import dan200.computercraft.shared.computer.inventory.ComputerMenuWithoutInventory;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.util.NBTUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jspecify.annotations.Nullable;

public class ComputerBlockEntity
extends AbstractComputerBlockEntity {
    private static final String NBT_TERMINAL_SIZE = "TerminalSize";
    private @Nullable TerminalSize terminalSize;
    private @Nullable IPeripheral peripheral;

    public ComputerBlockEntity(BlockEntityType<? extends ComputerBlockEntity> type, BlockPos pos, BlockState state, ComputerFamily family) {
        super(type, pos, state, family);
    }

    @Override
    protected void loadServer(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadServer(nbt, registries);
        this.terminalSize = NBTUtil.decodeFrom(TerminalSize.CODEC, registries, nbt, NBT_TERMINAL_SIZE);
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        NBTUtil.encodeTo(TerminalSize.CODEC, registries, nbt, NBT_TERMINAL_SIZE, this.terminalSize);
    }

    @Override
    protected void loadClient(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadClient(nbt, registries);
        this.terminalSize = NBTUtil.decodeFrom(TerminalSize.CODEC, registries, nbt, NBT_TERMINAL_SIZE);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        NBTUtil.encodeTo(TerminalSize.CODEC, registries, tag, NBT_TERMINAL_SIZE, this.terminalSize);
        return tag;
    }

    @Override
    protected void applyImplicitComponents(BlockEntity.DataComponentInput component) {
        super.applyImplicitComponents(component);
        this.terminalSize = (TerminalSize)component.get((DataComponentType)ModRegistry.DataComponents.TERMINAL_SIZE.get());
    }

    @Override
    protected void collectSafeComponents(DataComponentMap.Builder builder) {
        super.collectSafeComponents(builder);
        builder.set((DataComponentType)ModRegistry.DataComponents.TERMINAL_SIZE.get(), (Object)this.terminalSize);
    }

    @Override
    @Deprecated
    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove(NBT_TERMINAL_SIZE);
    }

    @Override
    protected ServerComputer createComputer(int id) {
        return new ServerComputer((ServerLevel)this.getLevel(), this.getBlockPos(), ServerComputer.properties(id, this.getFamily()).label(this.getLabel()).terminalSize(this.terminalSize != null ? this.terminalSize : new TerminalSize((Integer)ConfigSpec.computerTermWidth.get(), (Integer)ConfigSpec.computerTermHeight.get())).storageCapacity(this.storageCapacity));
    }

    protected boolean isUsableByPlayer(Player player) {
        return this.isUsable(player);
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)ComputerBlock.FACING);
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
        BlockState existing = this.getBlockState();
        if (existing.getValue(ComputerBlock.STATE) != newState) {
            this.getLevel().setBlock(this.getBlockPos(), (BlockState)existing.setValue(ComputerBlock.STATE, (Comparable)((Object)newState)), 2);
        }
    }

    @Override
    protected ComputerSide remapLocalSide(ComputerSide localSide) {
        if (localSide == ComputerSide.RIGHT) {
            return ComputerSide.LEFT;
        }
        if (localSide == ComputerSide.LEFT) {
            return ComputerSide.RIGHT;
        }
        return localSide;
    }

    public @Nullable AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new ComputerMenuWithoutInventory((MenuType<? extends AbstractComputerMenu>)((MenuType)ModRegistry.Menus.COMPUTER.get()), id, inventory, this::isUsableByPlayer, this.createServerComputer());
    }

    public IPeripheral peripheral() {
        if (this.peripheral != null) {
            return this.peripheral;
        }
        this.peripheral = new ComputerPeripheral("computer", this);
        return this.peripheral;
    }
}

