/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media.items;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.core.filesystem.SubMount;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.items.TreasureDisk;
import java.io.IOException;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import org.jspecify.annotations.Nullable;

public final class TreasureDiskMedia
implements IMedia {
    public static final IMedia INSTANCE = new TreasureDiskMedia();

    private TreasureDiskMedia() {
    }

    @Override
    public String getLabel(HolderLookup.Provider registries, ItemStack stack) {
        return TreasureDisk.getTitle((DataComponentHolder)stack);
    }

    @Override
    public @Nullable Mount createDataMount(ItemStack stack, ServerLevel level) {
        Mount rootTreasure = ComputerCraftAPI.createResourceMount(level.getServer(), "computercraft", "lua/treasure");
        if (rootTreasure == null) {
            return null;
        }
        TreasureDisk treasureDisk = (TreasureDisk)stack.get((DataComponentType)ModRegistry.DataComponents.TREASURE_DISK.get());
        if (treasureDisk == null) {
            return null;
        }
        String subPath = treasureDisk.path();
        try {
            if (rootTreasure.exists(subPath)) {
                return new SubMount(rootTreasure, subPath);
            }
            if (rootTreasure.exists("deprecated/" + subPath)) {
                return new SubMount(rootTreasure, "deprecated/" + subPath);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

