/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.modem.wired;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlockEntity;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.util.RegistryHelper;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jspecify.annotations.Nullable;

public abstract class CableBlockItem
extends BlockItem {
    private @Nullable String translationKey;

    public CableBlockItem(CableBlock block, Item.Properties settings) {
        super((Block)block, settings);
    }

    boolean placeAt(Level world, BlockPos pos, BlockState state) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            return false;
        }
        world.setBlockAndUpdate(pos, state);
        SoundType soundType = state.getSoundType();
        world.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof CableBlockEntity) {
            CableBlockEntity cable = (CableBlockEntity)tile;
            cable.connectionsChanged();
        }
        return true;
    }

    boolean placeAtCorrected(Level world, BlockPos pos, BlockState state) {
        return this.placeAt(world, pos, CableBlock.correctConnections(world, pos, state));
    }

    public String getDescriptionId() {
        if (this.translationKey == null) {
            this.translationKey = Util.makeDescriptionId((String)"block", (ResourceLocation)RegistryHelper.getKeyOrThrow(BuiltInRegistries.ITEM, this));
        }
        return this.translationKey;
    }

    public static class Cable
    extends CableBlockItem {
        public Cable(CableBlock block, Item.Properties settings) {
            super(block, settings);
        }

        public InteractionResult place(BlockPlaceContext context) {
            BlockPos pos;
            BlockPos insidePos;
            ItemStack stack = context.getItemInHand();
            if (stack.isEmpty()) {
                return InteractionResult.FAIL;
            }
            Level world = context.getLevel();
            BlockState insideState = world.getBlockState(insidePos = (pos = context.getClickedPos()).relative(context.getClickedFace().getOpposite()));
            if (insideState.getBlock() == ModRegistry.Blocks.CABLE.get() && !((Boolean)insideState.getValue((Property)CableBlock.CABLE)).booleanValue() && this.placeAtCorrected(world, insidePos, (BlockState)insideState.setValue((Property)CableBlock.CABLE, (Comparable)Boolean.valueOf(true)))) {
                stack.shrink(1);
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
            BlockState existingState = world.getBlockState(pos);
            if (existingState.getBlock() == ModRegistry.Blocks.CABLE.get() && !((Boolean)existingState.getValue((Property)CableBlock.CABLE)).booleanValue() && this.placeAtCorrected(world, pos, (BlockState)existingState.setValue((Property)CableBlock.CABLE, (Comparable)Boolean.valueOf(true)))) {
                stack.shrink(1);
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
            return super.place(context);
        }
    }

    public static class WiredModem
    extends CableBlockItem {
        public WiredModem(CableBlock block, Item.Properties settings) {
            super(block, settings);
        }

        public InteractionResult place(BlockPlaceContext context) {
            Direction side;
            BlockState newState;
            BlockPos pos;
            ItemStack stack = context.getItemInHand();
            if (stack.isEmpty()) {
                return InteractionResult.FAIL;
            }
            Level world = context.getLevel();
            BlockState existingState = world.getBlockState(pos = context.getClickedPos());
            if (existingState.getBlock() == ModRegistry.Blocks.CABLE.get() && existingState.getValue(CableBlock.MODEM) == CableModemVariant.None && this.placeAt(world, pos, newState = (BlockState)((BlockState)existingState.setValue(CableBlock.MODEM, (Comparable)((Object)CableModemVariant.from(side = context.getClickedFace().getOpposite())))).setValue((Property)CableBlock.CONNECTIONS.get(side), (Comparable)((Boolean)existingState.getValue((Property)CableBlock.CABLE))))) {
                stack.shrink(1);
                return InteractionResult.sidedSuccess((boolean)world.isClientSide);
            }
            return super.place(context);
        }
    }
}

