/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jspecify.annotations.Nullable;

public final class DropConsumer {
    private static @Nullable Function<ItemStack, ItemStack> dropConsumer;
    private static @Nullable List<ItemStack> remainingDrops;
    private static @Nullable Level dropWorld;
    private static @Nullable AABB dropBounds;
    private static @Nullable Entity dropEntity;

    private DropConsumer() {
    }

    public static void set(Entity entity, Function<ItemStack, ItemStack> consumer) {
        dropConsumer = consumer;
        remainingDrops = new ArrayList<ItemStack>();
        dropEntity = entity;
        dropWorld = entity.level();
        dropBounds = new AABB(entity.blockPosition()).inflate(2.0, 2.0, 2.0);
    }

    public static void set(Level world, BlockPos pos, Function<ItemStack, ItemStack> consumer) {
        dropConsumer = consumer;
        remainingDrops = new ArrayList<ItemStack>(2);
        dropEntity = null;
        dropWorld = world;
        dropBounds = new AABB(pos).inflate(2.0, 2.0, 2.0);
    }

    public static List<ItemStack> clear() {
        List<ItemStack> remainingStacks = remainingDrops;
        if (remainingStacks == null) {
            throw new IllegalStateException("Not currently capturing");
        }
        dropConsumer = null;
        remainingDrops = null;
        dropEntity = null;
        dropWorld = null;
        dropBounds = null;
        return remainingStacks;
    }

    public static void clearAndDrop(Level world, BlockPos pos, @Nullable Direction direction) {
        List<ItemStack> remainingDrops = DropConsumer.clear();
        for (ItemStack remaining : remainingDrops) {
            WorldUtil.dropItemStack(world, pos, direction, remaining);
        }
    }

    private static void handleDrops(ItemStack stack) {
        ItemStack remaining = Nullability.assertNonNull(dropConsumer).apply(stack);
        if (!remaining.isEmpty()) {
            Nullability.assertNonNull(remainingDrops).add(remaining);
        }
    }

    public static boolean onEntitySpawn(Entity entity) {
        if (dropWorld == entity.level() && entity instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (Nullability.assertNonNull(dropBounds).contains(entity.position())) {
                DropConsumer.handleDrops(item.getItem());
                return true;
            }
        }
        return false;
    }

    public static boolean onLivingDrop(Entity entity, ItemStack stack) {
        if (entity != dropEntity) {
            return false;
        }
        DropConsumer.handleDrops(stack);
        return true;
    }
}

