/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.chisel.data;

import com.leclowndu93150.chisel.Chisel;
import com.leclowndu93150.chisel.api.block.ICarvable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CrossCollisionBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;

public class ChiselModelTemplates {
    public static String name(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public static String texturePath(Block block) {
        if (block instanceof ICarvable) {
            ICarvable carvable = (ICarvable)block;
            String blockType = carvable.getBlockType();
            String variation = carvable.getVariation().getTextureName();
            return blockType + "/" + variation;
        }
        return ChiselModelTemplates.name(block);
    }

    public static ModelTemplate simpleBlock() {
        return ChiselModelTemplates::simpleBlock;
    }

    private static void simpleBlock(BlockStateProvider prov, Block block) {
        prov.simpleBlock(block, (ModelFile)prov.models().cubeAll("block/" + ChiselModelTemplates.name(block), Chisel.id("block/" + ChiselModelTemplates.texturePath(block))));
    }

    public static ModelTemplate simpleBlockCutout() {
        return (prov, block) -> prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)prov.models().cubeAll("block/" + ChiselModelTemplates.name(block), Chisel.id("block/" + ChiselModelTemplates.texturePath(block)))).renderType("cutout"));
    }

    public static ModelTemplate simpleBlockTranslucent() {
        return (prov, block) -> prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)prov.models().cubeAll("block/" + ChiselModelTemplates.name(block), Chisel.id("block/" + ChiselModelTemplates.texturePath(block)))).renderType("translucent"));
    }

    public static ModelTemplate cloudBlock() {
        return (prov, block) -> prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("block/" + ChiselModelTemplates.name(block), Chisel.id("block/cube_all_translucent"))).texture("all", Chisel.id("block/" + ChiselModelTemplates.texturePath(block)))).renderType("translucent"));
    }

    public static String replaceVariant(String texPath, String newVariant) {
        int lastSlash = texPath.lastIndexOf(47);
        if (lastSlash >= 0) {
            return texPath.substring(0, lastSlash + 1) + newVariant;
        }
        return newVariant;
    }

    public static String replaceBlock(String texPath, String newBlock) {
        return texPath.replaceAll("^block/[^/]+", "block/" + newBlock);
    }

    public static ModelTemplate cubeBottomTop() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)prov.models().cubeBottomTop(modelName, Chisel.id(texPath + "-side"), Chisel.id(texPath + "-bottom"), Chisel.id(texPath + "-top")));
        };
    }

    public static ModelTemplate cubeBottomTop(String side, String bottom, String top) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)prov.models().cubeBottomTop(modelName, Chisel.id(ChiselModelTemplates.replaceVariant(texPath, side)), Chisel.id(ChiselModelTemplates.replaceVariant(texPath, bottom)), Chisel.id(ChiselModelTemplates.replaceVariant(texPath, top))));
        };
    }

    public static ModelTemplate cubeAll(String postfix) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)prov.models().cubeAll(modelName, Chisel.id(texPath + postfix)));
        };
    }

    public static ModelTemplate cubeColumn() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)prov.models().cubeColumn(modelName, Chisel.id(texPath + "-side"), Chisel.id(texPath + "-top")));
        };
    }

    public static ModelTemplate cubeColumnCutout() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)prov.models().cubeColumn(modelName, Chisel.id(texPath + "-side"), Chisel.id(texPath + "-top"))).renderType("cutout"));
        };
    }

    public static ModelTemplate cubeColumn(String side, String top) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)prov.models().cubeColumn(modelName, Chisel.id(ChiselModelTemplates.replaceVariant(texPath, side)), Chisel.id(ChiselModelTemplates.replaceVariant(texPath, top))));
        };
    }

    public static ModelTemplate bookshelf() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/bookshelf_base"))).texture("overlay", Chisel.id(texPath)));
        };
    }

    public static ModelTemplate bookshelf(String woodType) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String variantName = ChiselModelTemplates.getVariantName(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/bookshelf_base_" + woodType))).texture("overlay", Chisel.id("block/bookshelf/" + variantName)));
        };
    }

    public static ModelTemplate ctm(String variant) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            String texName = ChiselModelTemplates.replaceVariant(texPath, variant);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("cube_ctm"))).texture("all", texName)).texture("connected_tex", texName + "-ctm"));
        };
    }

    public static ModelTemplate twoLayerWithTop(String top, boolean shade) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id(shade ? "cube_2_layer" : "cube_2_layer_no_shade"))).texture("bot", texPath)).texture("top", ChiselModelTemplates.replaceVariant(texPath, top)));
        };
    }

    public static ModelTemplate axisFaces() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/cube_axis"))).texture("x", texPath + "-ew")).texture("y", texPath + "-tb")).texture("z", texPath + "-ns"));
        };
    }

    public static ModelTemplate axisFacesNoTop() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/cube_axis"))).texture("x", texPath + "-ew")).texture("y", texPath + "-ns")).texture("z", texPath + "-ns"));
        };
    }

    public static ModelTemplate mossy(String base) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            String texName = ChiselModelTemplates.replaceBlock(texPath, base);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/mossy/mossy"))).texture("bot", texName));
        };
    }

    public static ModelTemplate mossyColumn(String base) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            String texName = ChiselModelTemplates.replaceBlock(texPath, base);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/mossy/mossy_column"))).texture("side", texName + "-side")).texture("end", texName + "-top"));
        };
    }

    public static ModelTemplate mossyCtm(String base, String variant) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            String texName = ChiselModelTemplates.replaceBlock(texPath, base);
            texName = ChiselModelTemplates.replaceVariant(texName, variant);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/mossy/mossy_ctm"))).texture("bot", texName)).texture("connect_bot", texName + "-ctm"));
        };
    }

    public static ModelTemplate twoLayerTopShaded(String top, String bottom) {
        return ChiselModelTemplates.twoLayerTopShaded(top, top, bottom);
    }

    public static ModelTemplate twoLayerTopShaded(String particle, String top, String bottom) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/cube_2_layer_topshaded"))).texture("particle", ChiselModelTemplates.replaceVariant(texPath, particle))).texture("top", ChiselModelTemplates.replaceVariant(texPath, top))).texture("bot", ChiselModelTemplates.replaceVariant(texPath, bottom)));
        };
    }

    public static ModelTemplate threeLayerTopShaded(String particle, String top, String mid, String bottom) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/cube_3_layer_topshaded"))).texture("particle", ChiselModelTemplates.replaceVariant(texPath, particle))).texture("top", ChiselModelTemplates.replaceVariant(texPath, top))).texture("mid", ChiselModelTemplates.replaceVariant(texPath, mid))).texture("bot", ChiselModelTemplates.replaceVariant(texPath, bottom)));
        };
    }

    public static ModelTemplate cubeCTMTranslucent(String all, String ctm) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/cube_ctm_translucent"))).texture("all", all)).texture("connected_tex", ctm));
        };
    }

    public static ModelTemplate fluidCube(String fluid) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String variant = ChiselModelTemplates.getVariantName(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/" + fluid + "stone/cube_" + fluid))).texture("bot", ResourceLocation.withDefaultNamespace((String)("block/" + fluid + "_still")))).texture("top", Chisel.id("block/fluid/" + variant)));
        };
    }

    public static ModelTemplate fluidCubeCTM(String fluid, String variant) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/" + fluid + "stone/cube_ctm_" + fluid))).texture("bot", ResourceLocation.withDefaultNamespace((String)("block/" + fluid + "_still")))).texture("top", Chisel.id("block/fluid/" + variant))).texture("connect_top", Chisel.id("block/fluid/" + variant + "-ctm")));
        };
    }

    public static ModelTemplate fluidPassCube(String fluid) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String variant = ChiselModelTemplates.getVariantName(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/" + fluid + "stone/cube_pass_" + fluid))).texture("bot", ResourceLocation.withDefaultNamespace((String)("block/" + fluid + "_still")))).texture("top", Chisel.id("block/fluid/" + variant)));
        };
    }

    public static ModelTemplate fluidPassColumn(String fluid) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String variant = ChiselModelTemplates.getVariantName(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/" + fluid + "stone/column_" + fluid))).texture("bot", ResourceLocation.withDefaultNamespace((String)("block/" + fluid + "_still")))).texture("side", Chisel.id("block/fluid/" + variant + "-side"))).texture("top", Chisel.id("block/fluid/" + variant + "-top")));
        };
    }

    private static String getVariantName(Block block) {
        if (block instanceof ICarvable) {
            ICarvable carvable = (ICarvable)block;
            return carvable.getVariation().getTextureName();
        }
        String name = ChiselModelTemplates.name(block);
        return name.contains("/") ? name.split("/")[1] : name;
    }

    public static ModelTemplate cubeEldritch() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/cube_eldritch"))).texture("all", texPath));
        };
    }

    public static ModelTemplate columnEldritch(String top) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/column_eldritch"))).texture("end", ChiselModelTemplates.replaceVariant(texPath, top) + "-top")).texture("side", texPath + "-side"));
        };
    }

    public static ModelTemplate columnPillar() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/column_pillar"))).texture("top", texPath + "-top")).texture("pillar", texPath + "-ctmv"));
        };
    }

    public static ModelTemplate hexPlate(String variant) {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/cube_2_layer"))).texture("top", Chisel.id("block/hexplating/" + variant))).texture("bot", Chisel.id("block/animations/archetype2")));
        };
    }

    public static ModelTemplate cube(String texture) {
        return (prov, block) -> prov.simpleBlock(block, (ModelFile)prov.models().cubeAll("block/" + ChiselModelTemplates.name(block), Chisel.id(texture)));
    }

    public static ModelTemplate paneBlock(String edge) {
        return (prov, block) -> {
            String name = "block/" + ChiselModelTemplates.name(block);
            String texture = "block/" + ChiselModelTemplates.name(block).replace("pane", "");
            ChiselModelTemplates.paneBlockInternal(prov, block, name, Chisel.id(texture), Chisel.id(edge));
        };
    }

    public static ModelTemplate paneBlockSideTop() {
        return (prov, block) -> {
            String name = "block/" + ChiselModelTemplates.name(block);
            String basePath = "block/" + ChiselModelTemplates.texturePath(block);
            ResourceLocation paneTexture = Chisel.id(basePath + "-side");
            ResourceLocation edgeTexture = Chisel.id(basePath + "-top");
            ChiselModelTemplates.paneBlockVanillaStyle(prov, block, name, paneTexture, edgeTexture);
        };
    }

    private static void paneBlockVanillaStyle(BlockStateProvider prov, Block block, String name, ResourceLocation paneTexture, ResourceLocation edgeTexture) {
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder(block);
        BlockModelBuilder postModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_post", ResourceLocation.withDefaultNamespace((String)"block/template_glass_pane_post"))).texture("pane", paneTexture)).texture("edge", edgeTexture)).renderType("translucent");
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)postModel).addModel()).end();
        BlockModelBuilder sideModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_side", ResourceLocation.withDefaultNamespace((String)"block/template_glass_pane_side"))).texture("pane", paneTexture)).texture("edge", edgeTexture)).renderType("translucent");
        BlockModelBuilder sideAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_side_alt", ResourceLocation.withDefaultNamespace((String)"block/template_glass_pane_side_alt"))).texture("pane", paneTexture)).texture("edge", edgeTexture)).renderType("translucent");
        BlockModelBuilder nosideModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_noside", ResourceLocation.withDefaultNamespace((String)"block/template_glass_pane_noside"))).texture("pane", paneTexture)).renderType("translucent");
        BlockModelBuilder nosideAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_noside_alt", ResourceLocation.withDefaultNamespace((String)"block/template_glass_pane_noside_alt"))).texture("pane", paneTexture)).renderType("translucent");
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)nosideModel).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)nosideAltModel).addModel()).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).addModel()).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)nosideAltModel).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)nosideModel).rotationY(270).addModel()).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{false}).end();
    }

    private static void paneBlockInternal(BlockStateProvider prov, Block block, String name, ResourceLocation texture, ResourceLocation edge) {
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder(block);
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_post", Chisel.id("block/pane/post"))).texture("pane", texture)).texture("edge", edge)).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_n", Chisel.id("block/pane/n"))).texture("pane", texture)).texture("edge", edge)).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_e", Chisel.id("block/pane/e"))).texture("pane", texture)).texture("edge", edge)).addModel()).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_s", Chisel.id("block/pane/s"))).texture("pane", texture)).texture("edge", edge)).addModel()).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_w", Chisel.id("block/pane/w"))).texture("pane", texture)).texture("edge", edge)).addModel()).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{true}).end();
    }

    public static ModelTemplate bars(String texture, String edge, String side) {
        return (prov, block) -> {
            String name = "block/" + ChiselModelTemplates.name(block);
            ResourceLocation tex = Chisel.id(texture);
            ResourceLocation edgeTex = Chisel.id(edge);
            ResourceLocation sideTex = Chisel.id(side);
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder(block);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_post_ends", Chisel.id("block/bars_post_ends"))).texture("bars", tex)).texture("particle", tex)).texture("edge", edgeTex)).texture("side", sideTex)).addModel()).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_post", Chisel.id("block/bars_post"))).texture("bars", tex)).texture("particle", tex)).texture("edge", edgeTex)).texture("side", sideTex)).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{false}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_side", Chisel.id("block/bars_side"))).texture("bars", tex)).texture("particle", tex)).texture("edge", edgeTex)).texture("side", sideTex)).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)prov.models().getExistingFile(Chisel.id(name + "_side"))).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_side_alt", Chisel.id("block/bars_side_alt"))).texture("bars", tex)).texture("particle", tex)).texture("edge", edgeTex)).texture("side", sideTex)).addModel()).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)prov.models().getExistingFile(Chisel.id(name + "_side_alt"))).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{true}).end();
        };
    }

    public static ModelTemplate ironBars() {
        return (prov, block) -> {
            String name = "block/" + ChiselModelTemplates.name(block);
            String basePath = "block/" + ChiselModelTemplates.texturePath(block);
            ResourceLocation barsTexture = Chisel.id(basePath);
            ResourceLocation edgeTexture = Chisel.id(basePath);
            ChiselModelTemplates.ironBarsVanillaStyle(prov, block, name, barsTexture, edgeTexture);
        };
    }

    private static void ironBarsVanillaStyle(BlockStateProvider prov, Block block, String name, ResourceLocation barsTexture, ResourceLocation edgeTexture) {
        MultiPartBlockStateBuilder builder = prov.getMultipartBuilder(block);
        BlockModelBuilder postEndsModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_post_ends", ResourceLocation.withDefaultNamespace((String)"block/iron_bars_post_ends"))).texture("particle", barsTexture)).texture("edge", edgeTexture)).renderType("cutout");
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)postEndsModel).addModel()).end();
        BlockModelBuilder postModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_post", ResourceLocation.withDefaultNamespace((String)"block/iron_bars_post"))).texture("particle", barsTexture)).texture("bars", barsTexture)).renderType("cutout");
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)postModel).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{false}).end();
        BlockModelBuilder capModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_cap", ResourceLocation.withDefaultNamespace((String)"block/iron_bars_cap"))).texture("particle", barsTexture)).texture("bars", barsTexture)).texture("edge", edgeTexture)).renderType("cutout");
        BlockModelBuilder capAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_cap_alt", ResourceLocation.withDefaultNamespace((String)"block/iron_bars_cap_alt"))).texture("particle", barsTexture)).texture("bars", barsTexture)).texture("edge", edgeTexture)).renderType("cutout");
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)capModel).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)capModel).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{true}).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)capAltModel).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{true}).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{false}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)capAltModel).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{false}).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{true}).end();
        BlockModelBuilder sideModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_side", ResourceLocation.withDefaultNamespace((String)"block/iron_bars_side"))).texture("particle", barsTexture)).texture("bars", barsTexture)).texture("edge", edgeTexture)).renderType("cutout");
        BlockModelBuilder sideAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_side_alt", ResourceLocation.withDefaultNamespace((String)"block/iron_bars_side_alt"))).texture("particle", barsTexture)).texture("bars", barsTexture)).texture("edge", edgeTexture)).renderType("cutout");
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).addModel()).condition((Property)CrossCollisionBlock.NORTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.EAST, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).addModel()).condition((Property)CrossCollisionBlock.SOUTH, (Comparable[])new Boolean[]{true}).end();
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).rotationY(90).addModel()).condition((Property)CrossCollisionBlock.WEST, (Comparable[])new Boolean[]{true}).end();
    }

    public static ModelTemplate woolCtm() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("cube_ctm"))).texture("all", Chisel.id(texPath))).texture("connected_tex", Chisel.id(texPath + "-ctm")));
        };
    }

    public static ModelTemplate carpetCtm() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block).replace("carpet/", "wool/");
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/carpet_ctm"))).texture("all", Chisel.id(texPath))).texture("all_ctm", Chisel.id(texPath + "-ctm")));
        };
    }

    public static ModelTemplate mysteriousCube() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/futura/mysterious_cube_base"))).texture("core", Chisel.id(ChiselModelTemplates.replaceVariant(texPath, "mysterious_cube_core")))).texture("side", Chisel.id(ChiselModelTemplates.replaceVariant(texPath, "mysterious_cube_side")))).texture("top", Chisel.id(ChiselModelTemplates.replaceVariant(texPath, "mysterious_cube_top")))).texture("bottom", Chisel.id(ChiselModelTemplates.replaceVariant(texPath, "mysterious_cube_bottom")))).renderType("cutout"));
        };
    }

    public static ModelTemplate ae2Controller() {
        return (prov, block) -> {
            String modelName = "block/" + ChiselModelTemplates.name(block);
            String texPath = "block/" + ChiselModelTemplates.texturePath(block);
            prov.simpleBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(modelName, Chisel.id("block/futura/ae2_controller_base"))).texture("block", Chisel.id(ChiselModelTemplates.replaceVariant(texPath, "ae2_controller")))).texture("lights", Chisel.id(ChiselModelTemplates.replaceVariant(texPath, "ae2_controller_lights")))).renderType("cutout"));
        };
    }

    @FunctionalInterface
    public static interface ModelTemplate {
        public void apply(BlockStateProvider var1, Block var2);
    }
}

