/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.block.RecipePipeBlock;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.container.FilterContainer;
import jagm.classicpipes.inventory.menu.RecipePipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.RequestedItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RecipePipeEntity
extends NetworkedPipeEntity
implements MenuProvider {
    private static final byte DEFAULT_COOLDOWN = 8;
    private final FilterContainer filter = new FilterContainer(this, 10, true);
    private final Direction[] slotDirections = new Direction[10];
    private final NonNullList<ItemStack> heldItems;
    private int waitingForCraft;
    private boolean crafterTicked;
    private byte cooldown;
    private boolean blockingMode;

    public RecipePipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.RECIPE_PIPE_ENTITY, pos, state);
        List<Direction> buttonDirections = this.getDirectionsForButtons(state);
        Arrays.fill(this.slotDirections, buttonDirections.isEmpty() ? Direction.DOWN : buttonDirections.getFirst());
        this.heldItems = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        this.blockingMode = true;
    }

    public Direction[] getSlotDirections() {
        return this.slotDirections;
    }

    public void setSlotDirection(int slot, Direction direction) {
        this.slotDirections[slot] = direction;
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        BlockPos crafterPos = pos.relative(this.slotDirections[9]);
        if (this.crafterTicked && this.hasNetwork()) {
            for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                if (!requestedItem.matches(this.getResult())) continue;
                requestedItem.sendMessage(level, (Component)Component.translatable((String)"chat.classicpipes.crafter_jammed", (Object[])new Object[]{crafterPos.toShortString()}).withStyle(ChatFormatting.RED));
            }
            this.getNetwork().resetRequests(level);
            this.crafterTicked = false;
            this.waitingForCraft = 0;
            this.setChanged();
            level.sendBlockUpdated(pos, state, state, 2);
        } else if (this.waitingForCraft > 0) {
            BlockEntity container = level.getBlockEntity(crafterPos);
            if (container instanceof CrafterBlockEntity) {
                CrafterBlockEntity crafter = (CrafterBlockEntity)container;
                if (this.isEmpty()) {
                    level.scheduleTick(crafterPos, crafter.getBlockState().getBlock(), 0);
                    level.playSound(null, crafterPos, SoundEvents.CRAFTER_CRAFT, SoundSource.BLOCKS);
                    this.crafterTicked = true;
                }
            } else {
                byte by = this.cooldown;
                this.cooldown = (byte)(by - 1);
                if (by <= 0) {
                    if (!(container instanceof ItemPipeEntity) && Services.LOADER_SERVICE.extractSpecificItem(this, level, crafterPos, this.slotDirections[9].getOpposite(), this.getResult().copyWithCount(1))) {
                        level.sendBlockUpdated(pos, state, state, 2);
                        this.setChanged();
                    }
                    this.cooldown = (byte)8;
                }
            }
        } else if (!this.queued.isEmpty()) {
            this.addQueuedItems((Level)level, false);
        }
    }

    @Override
    public void update(ServerLevel level, BlockState state, BlockPos pos, Direction direction, boolean wasConnected) {
        super.update(level, state, pos, direction, wasConnected);
        this.checkSlotDirections();
    }

    @Override
    protected void initialiseNetworking(ServerLevel level, BlockState state, BlockPos pos) {
        super.initialiseNetworking(level, state, pos);
        this.checkSlotDirections();
    }

    private void checkSlotDirections() {
        List<Direction> buttonDirections = this.getDirectionsForButtons(this.getBlockState());
        if (!buttonDirections.isEmpty()) {
            for (int i = 0; i < this.slotDirections.length; ++i) {
                if (buttonDirections.contains(this.slotDirections[i])) continue;
                this.slotDirections[i] = buttonDirections.getFirst();
                this.setChanged();
            }
        }
    }

    @Override
    public void eject(ServerLevel level, BlockPos pos, ItemInPipe item) {
        ArrayList<Integer> matchingSlots = new ArrayList<Integer>();
        for (int slot = 0; slot < 9; ++slot) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)this.filter.getItem(slot), (ItemStack)item.getStack())) continue;
            matchingSlots.add(slot);
        }
        if (!matchingSlots.isEmpty()) {
            ItemStack stack = item.getStack().copy();
            while (!stack.isEmpty()) {
                int minSlot = (Integer)matchingSlots.getFirst();
                int minAmount = ((ItemStack)this.heldItems.get(minSlot)).getCount();
                Iterator iterator = matchingSlots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    int slotAmount = ((ItemStack)this.heldItems.get(slot)).getCount();
                    if (slotAmount >= minAmount) continue;
                    minSlot = slot;
                    minAmount = slotAmount;
                }
                this.heldItems.set(minSlot, (Object)stack.copyWithCount(((ItemStack)this.heldItems.get(minSlot)).getCount() + 1));
                stack.shrink(1);
            }
        } else {
            super.eject(level, pos, item);
        }
        this.attemptCraft();
        this.setChanged();
    }

    private void attemptCraft() {
        if (this.waitingForCraft == 0 || !this.blockingMode) {
            int readyToCraft = Integer.MAX_VALUE;
            for (int slot = 0; slot < 9; ++slot) {
                if (!this.filter.getItem(slot).isEmpty()) {
                    readyToCraft = Math.min(readyToCraft, ((ItemStack)this.heldItems.get(slot)).getCount() / this.filter.getItem(slot).getCount());
                }
                BlockState state = this.getBlockState();
                if (this.filter.getItem(slot).isEmpty() || ((NetworkedPipeBlock.ConnectionState)((Object)state.getValue((Property)RecipePipeBlock.PROPERTY_BY_DIRECTION.get(this.slotDirections[slot])))).equals((Object)NetworkedPipeBlock.ConnectionState.UNLINKED)) continue;
                readyToCraft = 0;
                Level level = this.getLevel();
                if (!(level instanceof ServerLevel)) break;
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.hasNetwork()) break;
                for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                    if (!requestedItem.matches(this.getResult())) continue;
                    requestedItem.sendMessage(serverLevel, (Component)Component.translatable((String)"chat.classicpipes.missing_recipe_pipe_direction", (Object[])new Object[]{this.getBlockPos().toShortString()}).withStyle(ChatFormatting.RED));
                }
                this.crafterTicked = false;
                this.waitingForCraft = 0;
                this.getNetwork().resetRequests(serverLevel);
                this.setChanged();
                serverLevel.sendBlockUpdated(this.getBlockPos(), state, state, 2);
                break;
            }
            if (readyToCraft > 0 && readyToCraft < Integer.MAX_VALUE) {
                HashMap<Direction, CrafterBlockEntity> crafters = new HashMap<Direction, CrafterBlockEntity>();
                for (int i = 0; i < readyToCraft; ++i) {
                    for (int slot = 0; slot < 9; ++slot) {
                        BlockEntity blockEntity;
                        ItemStack ingredient = this.filter.getItem(slot);
                        if (crafters.containsKey(this.slotDirections[slot])) {
                            ((CrafterBlockEntity)crafters.get(this.slotDirections[slot])).setSlotState(slot, !ingredient.isEmpty());
                        } else if (this.getLevel() != null && (blockEntity = this.getLevel().getBlockEntity(this.getBlockPos().relative(this.slotDirections[slot]))) instanceof CrafterBlockEntity) {
                            CrafterBlockEntity crafter = (CrafterBlockEntity)blockEntity;
                            crafters.put(this.slotDirections[slot], crafter);
                            crafter.setSlotState(slot, !ingredient.isEmpty());
                        }
                        if (ingredient.isEmpty()) continue;
                        ((ItemStack)this.heldItems.get(slot)).shrink(ingredient.getCount());
                        this.queued.add(new ItemInPipe(ingredient.copy(), 64, 1024, Direction.DOWN, this.slotDirections[slot], false, 0));
                    }
                    this.waitingForCraft += this.getResult().getCount();
                }
            }
        }
    }

    public ItemStack getResult() {
        return this.filter.getItem(9).copy();
    }

    public List<ItemStack> getIngredients() {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            ItemStack ingredient = this.filter.getItem(i).copy();
            if (ingredient.isEmpty()) continue;
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    public List<ItemStack> getIngredientsCollated() {
        ArrayList<ItemStack> collated = new ArrayList<ItemStack>();
        for (ItemStack ingredient : this.getIngredients()) {
            MiscUtil.mergeStackIntoList(collated, ingredient);
        }
        return collated;
    }

    public NonNullList<ItemStack> getHeldItems() {
        return this.heldItems;
    }

    public void dropHeldItems(ServerLevel serverLevel, BlockPos pos) {
        for (ItemStack stack : this.heldItems) {
            if (stack.isEmpty()) continue;
            ItemEntity droppedItem = new ItemEntity((Level)serverLevel, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), stack);
            droppedItem.setDefaultPickUpDelay();
            serverLevel.addFreshEntity((Entity)droppedItem);
        }
        this.heldItems.clear();
    }

    @Override
    public void disconnect(ServerLevel level) {
        this.dropHeldItems(level, this.getBlockPos());
        super.disconnect(level);
    }

    @Override
    public void setRemoved() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            super.disconnect(serverLevel);
        }
        this.remove = true;
    }

    @Override
    public void insertPipeItem(Level level, ItemInPipe item) {
        ItemStack stack = item.getStack();
        if (!stack.isEmpty() && this.waitingForCraft > 0 && item.getFromDirection().equals((Object)this.slotDirections[9]) && ItemStack.isSameItemSameComponents((ItemStack)this.getResult(), (ItemStack)stack)) {
            this.waitingForCraft -= stack.getCount();
            this.crafterTicked = false;
            if (this.waitingForCraft <= 0) {
                this.waitingForCraft = 0;
                this.attemptCraft();
            }
        }
        super.insertPipeItem(level, item);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.classicpipes.recipe_pipe");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new RecipePipeMenu(id, playerInventory, this.filter, this.slotDirections, this.getDirectionsForButtons(this.getBlockState()), this.getBlockPos(), this.blockingMode);
    }

    public List<Direction> getDirectionsForButtons(BlockState state) {
        ArrayList<Direction> availableDirections = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if (!((NetworkedPipeBlock.ConnectionState)((Object)state.getValue((Property)NetworkedPipeBlock.PROPERTY_BY_DIRECTION.get(direction)))).equals((Object)NetworkedPipeBlock.ConnectionState.UNLINKED)) continue;
            availableDirections.add(direction);
        }
        return availableDirections;
    }

    @Override
    protected void loadAdditional(CompoundTag valueInput, HolderLookup.Provider registries) {
        this.filter.clearContent();
        this.heldItems.clear();
        super.loadAdditional(valueInput, registries);
        byte[] directionsByteList = valueInput.getByteArray("slot_directions");
        int i = 0;
        for (byte directionByte : directionsByteList) {
            if (i >= 10) break;
            this.slotDirections[i] = Direction.from3DDataValue((int)directionByte);
            ++i;
        }
        ListTag filterList = valueInput.getList("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                int slot = compoundTag.getInt("slot");
                MiscUtil.loadFromTag(tag, ItemStack.CODEC, registries, stack -> this.filter.setItem(slot, (ItemStack)stack));
            }
        });
        ListTag heldItemList = valueInput.getList("held_items", 10);
        heldItemList.forEach(tag -> {
            CompoundTag compoundTag;
            int slot;
            if (tag instanceof CompoundTag && (slot = (compoundTag = (CompoundTag)tag).getInt("slot")) >= 0 && slot < 9) {
                MiscUtil.loadFromTag(tag, ItemStack.CODEC, registries, stack -> this.heldItems.set(slot, stack));
            }
        });
        this.waitingForCraft = valueInput.getInt("waiting_for_craft");
        this.crafterTicked = valueInput.getBoolean("crafter_ticked");
        this.cooldown = valueInput.getByte("cooldown");
        this.blockingMode = valueInput.getBoolean("blocking_mode");
    }

    @Override
    protected void saveAdditional(CompoundTag valueOutput, HolderLookup.Provider registries) {
        super.saveAdditional(valueOutput, registries);
        byte[] directionsByteArray = new byte[10];
        for (int i = 0; i < this.slotDirections.length; ++i) {
            directionsByteArray[i] = this.slotDirections[i] == null ? (byte)0 : (byte)this.slotDirections[i].get3DDataValue();
        }
        valueOutput.putByteArray("slot_directions", directionsByteArray);
        ListTag filterList = new ListTag();
        for (int slot = 0; slot < this.filter.getContainerSize(); ++slot) {
            ItemStack stack = this.filter.getItem(slot);
            if (stack.isEmpty()) continue;
            CompoundTag tag = new CompoundTag();
            tag.putInt("slot", slot);
            MiscUtil.saveToTag((Tag)tag, stack, ItemStack.CODEC, registries, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.put("filter", (Tag)filterList);
        ListTag heldItemList = new ListTag();
        for (int slot = 0; slot < this.heldItems.size(); ++slot) {
            ItemStack stack = (ItemStack)this.heldItems.get(slot);
            if (stack.isEmpty()) continue;
            CompoundTag tag = new CompoundTag();
            tag.putInt("slot", slot);
            MiscUtil.saveToTag((Tag)tag, stack, ItemStack.CODEC, registries, arg_0 -> heldItemList.add(arg_0));
        }
        valueOutput.put("held_items", (Tag)heldItemList);
        valueOutput.putInt("waiting_for_craft", this.waitingForCraft);
        valueOutput.putBoolean("crafter_ticked", this.crafterTicked);
        valueOutput.putByte("cooldown", this.cooldown);
        valueOutput.putBoolean("blocking_mode", this.blockingMode);
    }

    public void setBlockingMode(boolean blockingMode) {
        this.blockingMode = blockingMode;
    }

    public boolean isBlockingMode() {
        return this.blockingMode;
    }
}

