/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.network;

import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.network.SelfHandler;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record ServerBoundRequestPayload(ItemStack stack, BlockPos requestPos) implements SelfHandler
{
    public static final CustomPacketPayload.Type<ServerBoundRequestPayload> TYPE = new CustomPacketPayload.Type(MiscUtil.resourceLocation("request"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerBoundRequestPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ServerBoundRequestPayload::stack, (StreamCodec)BlockPos.STREAM_CODEC, ServerBoundRequestPayload::requestPos, ServerBoundRequestPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void handle(Player player) {
        Level level = player.level();
        if (level instanceof ServerLevel) {
            NetworkedPipeEntity pipe;
            ServerLevel serverLevel = (ServerLevel)level;
            level = player.level().getBlockEntity(this.requestPos());
            if (level instanceof NetworkedPipeEntity && (pipe = (NetworkedPipeEntity)level).hasNetwork()) {
                pipe.getNetwork().request(serverLevel, this.stack(), this.requestPos(), player, false);
            }
        }
    }
}

