/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.ClientBoundItemListPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.RequestState;
import jagm.classicpipes.util.RequestedItem;
import jagm.classicpipes.util.SortingMode;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;

public class PipeNetwork {
    private static final byte DEFAULT_COOLDOWN = 40;
    private final BlockPos pos;
    private final Set<RoutingPipeEntity> routingPipes = new HashSet<RoutingPipeEntity>();
    private final Set<NetworkedPipeEntity> defaultRoutes = new HashSet<NetworkedPipeEntity>();
    private final Set<ProviderPipe> providerPipes = new LinkedHashSet<ProviderPipe>();
    private final Set<StockingPipeEntity> stockingPipes = new HashSet<StockingPipeEntity>();
    private final Set<MatchingPipe> matchingPipes = new HashSet<MatchingPipe>();
    private final Set<RecipePipeEntity> recipePipes = new HashSet<RecipePipeEntity>();
    private SortingMode sortingMode;
    private boolean cacheChanged;
    private byte cacheCooldown;
    private final List<RequestedItem> requestedItems;

    public PipeNetwork(BlockPos pos, SortingMode sortingMode) {
        this.sortingMode = sortingMode;
        this.pos = pos;
        this.cacheChanged = false;
        this.cacheCooldown = 0;
        this.requestedItems = new ArrayList<RequestedItem>();
    }

    public PipeNetwork(BlockPos pos) {
        this(pos, SortingMode.AMOUNT_DESCENDING);
    }

    private Tuple<Integer, Boolean> amountCraftable(ItemStack stack, int requiredAmount, BlockPos requestPos, RequestState requestState, List<ItemStack> itemsInThisBranch) {
        int amount = 0;
        boolean hasRecipe = false;
        int missingStacksSize = requestState.missingStacksSize();
        for (RecipePipeEntity recipePipe : this.recipePipes) {
            Object ingredientStack32;
            ItemStack resultStack = recipePipe.getResult();
            if (!ItemStack.isSameItemSameComponents((ItemStack)resultStack, (ItemStack)stack)) continue;
            hasRecipe = true;
            requestState.reduceMissingStacks(missingStacksSize);
            List<ItemStack> ingredients = recipePipe.getIngredientsCollated();
            int requiredCrafts = Math.ceilDiv(requiredAmount, resultStack.getCount());
            boolean loopFound = false;
            for (ItemStack itemStack : ingredients) {
                for (ItemStack branchStack : itemsInThisBranch) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)branchStack, (ItemStack)itemStack)) continue;
                    missingStacksSize = requestState.missingStacksSize();
                    requestState.addMissingStack(itemStack.copyWithCount(itemStack.getCount() * requiredCrafts));
                    loopFound = true;
                    break;
                }
                if (!loopFound) continue;
                break;
            }
            if (loopFound) continue;
            int possibleCrafts = requiredCrafts;
            for (Object ingredientStack32 : ingredients) {
                ArrayList<ItemStack> newBranchItems = new ArrayList<ItemStack>(itemsInThisBranch);
                newBranchItems.add((ItemStack)ingredientStack32);
                RequestState backupState = requestState.copy();
                int requiredIngredientAmount = ingredientStack32.getCount() * requiredCrafts;
                int ingredientAmount = this.availableAmount(ingredientStack32.copyWithCount(requiredIngredientAmount), recipePipe.getBlockPos(), requestState, newBranchItems);
                possibleCrafts = Math.min(possibleCrafts, ingredientAmount / ingredientStack32.getCount());
                requestState.restore(backupState);
            }
            if (possibleCrafts <= 0) continue;
            int n = requestState.missingStacksSize();
            ingredientStack32 = ingredients.iterator();
            while (ingredientStack32.hasNext()) {
                ItemStack ingredientStack4 = (ItemStack)ingredientStack32.next();
                ArrayList<ItemStack> newBranchItems = new ArrayList<ItemStack>(itemsInThisBranch);
                newBranchItems.add(ingredientStack4);
                int possibleIngredientAmount = ingredientStack4.getCount() * possibleCrafts;
                this.availableAmount(ingredientStack4.copyWithCount(possibleIngredientAmount), recipePipe.getBlockPos(), requestState, newBranchItems);
            }
            requestState.reduceMissingStacks(n);
            int amountToDeliver = Math.min(resultStack.getCount() * possibleCrafts, requiredAmount);
            amount += amountToDeliver;
            requestState.scheduleItemRouting(requestPos, resultStack.copyWithCount(amountToDeliver));
            missingStacksSize = requestState.missingStacksSize();
            requestState.addCraftedItem(resultStack);
            if ((requiredAmount -= resultStack.getCount() * possibleCrafts) > 0) continue;
            if (requiredAmount >= 0) break;
            requestState.addSpareStack(stack.copyWithCount(-requiredAmount));
            break;
        }
        return new Tuple<Integer, Boolean>(amount, hasRecipe);
    }

    private int amountInNetwork(ItemStack stack, BlockPos requestPos, RequestState requestState) {
        int amount = 0;
        for (ItemStack spareStack : requestState.getSpareStacks()) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)spareStack, (ItemStack)stack)) continue;
            int spareAmount = Math.min(spareStack.getCount(), stack.getCount());
            if (spareAmount <= 0) break;
            amount += spareAmount;
            spareStack.shrink(spareAmount);
            requestState.scheduleItemRouting(requestPos, stack.copyWithCount(spareAmount));
            break;
        }
        requestState.getSpareStacks().removeIf(ItemStack::isEmpty);
        if (amount < stack.getCount()) {
            for (ProviderPipe providerPipe : this.providerPipes) {
                for (ItemStack cacheStack : providerPipe.getCache()) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)cacheStack, (ItemStack)stack)) continue;
                    int amountProvidable = Math.min(stack.getCount() - amount, cacheStack.getCount() - requestState.amountAlreadyWithdrawing(providerPipe, stack));
                    if (amountProvidable <= 0) break;
                    amount += amountProvidable;
                    requestState.scheduleItemWithdrawal(providerPipe, stack.copyWithCount(amountProvidable));
                    requestState.scheduleItemRouting(requestPos, stack.copyWithCount(amountProvidable));
                    break;
                }
                if (amount < stack.getCount()) continue;
                break;
            }
        }
        return amount;
    }

    private int availableAmount(ItemStack stack, BlockPos requestPos, RequestState requestState, List<ItemStack> itemsInThisBranch) {
        int amount = this.amountInNetwork(stack, requestPos, requestState);
        if (amount < stack.getCount()) {
            Tuple<Integer, Boolean> tuple = this.amountCraftable(stack, stack.getCount() - amount, requestPos, requestState, itemsInThisBranch);
            amount += tuple.a().intValue();
            if (!tuple.b().booleanValue()) {
                requestState.addMissingStack(stack.copyWithCount(stack.getCount() - amount));
            }
        }
        return amount;
    }

    public void request(ServerLevel level, ItemStack stack, BlockPos requestPos, Player player, boolean partialRequests) {
        RequestState requestState = new RequestState();
        int amount = this.availableAmount(stack, requestPos, requestState, new ArrayList<ItemStack>());
        if (amount < stack.getCount()) {
            if (partialRequests) {
                this.request(level, stack.copyWithCount(amount), requestPos, player, false);
            } else if (player != null) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.missing_item.a", (Object[])new Object[]{stack.getCount(), stack.getItem().getDescription()}).withStyle(ChatFormatting.RED), false);
                for (ItemStack missingStack : requestState.collateMissingStacks()) {
                    player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.missing_item.b", (Object[])new Object[]{missingStack.getCount(), missingStack.getItem().getDescription()}).withStyle(ChatFormatting.YELLOW), false);
                }
            }
        } else {
            String playerName = player != null ? player.getName().getString() : "";
            int requestedItemsSize = this.requestedItems.size();
            for (Map.Entry<BlockPos, List<ItemStack>> entry : requestState.getItemsToRoute().entrySet()) {
                for (ItemStack routeStack : entry.getValue()) {
                    this.requestedItems.add(new RequestedItem(routeStack, entry.getKey(), playerName));
                }
            }
            boolean success = true;
            for (Map.Entry<ProviderPipe, List<ItemStack>> entry : requestState.getItemsToWithdraw().entrySet()) {
                for (ItemStack withdrawStack : entry.getValue()) {
                    boolean withdrawalSuccessful = false;
                    for (ItemStack cacheStack : entry.getKey().getCache()) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)cacheStack, (ItemStack)withdrawStack)) continue;
                        int amountToExtract = Math.min(cacheStack.getCount(), withdrawStack.getCount());
                        withdrawalSuccessful = entry.getKey().extractItem(level, cacheStack.copyWithCount(amountToExtract));
                        break;
                    }
                    if (withdrawalSuccessful) continue;
                    success = false;
                    while (this.requestedItems.size() > requestedItemsSize) {
                        this.requestedItems.removeLast();
                    }
                    if (player == null) break;
                    player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.could_not_extract", (Object[])new Object[]{stack.getCount(), stack.getItem().getDescription(), entry.getKey().getProviderPipePos().toShortString()}).withStyle(ChatFormatting.RED), false);
                    break;
                }
                if (success) continue;
                break;
            }
            if (success && player != null) {
                player.awardStat(ClassicPipes.ITEMS_REQUESTED_STAT, stack.getCount());
                ClassicPipes.REQUEST_ITEM_TRIGGER.trigger((ServerPlayer)player, stack, requestState.getUniqueCrafts());
                player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.requested", (Object[])new Object[]{stack.getCount(), stack.getItem().getDescription()}).withStyle(ChatFormatting.GREEN), false);
            }
        }
    }

    public void tick(ServerLevel level) {
        int updatablePipesCount = this.providerPipes.size() + this.matchingPipes.size() + this.stockingPipes.size();
        int pipeToUpdate = level.getRandom().nextInt(Math.max(100, updatablePipesCount));
        if (pipeToUpdate < this.providerPipes.size()) {
            i = 0;
            for (ProviderPipe providerPipe : this.providerPipes) {
                if (i == pipeToUpdate) {
                    Direction facing = providerPipe.getFacing();
                    if (facing == null) break;
                    providerPipe.updateCache();
                    break;
                }
                ++i;
            }
        } else if (pipeToUpdate < this.providerPipes.size() + this.matchingPipes.size()) {
            i = 0;
            for (MatchingPipe matchingPipe : this.matchingPipes) {
                if (i == pipeToUpdate) {
                    matchingPipe.updateCache();
                    break;
                }
                ++i;
            }
        } else if (pipeToUpdate < updatablePipesCount) {
            i = 0;
            for (Object stockingPipe : this.stockingPipes) {
                if (i == pipeToUpdate) {
                    stockingPipe.updateCache();
                    break;
                }
                ++i;
            }
        }
        if (this.cacheChanged && this.cacheCooldown <= 0) {
            List playerList = level.getPlayers(player -> {
                RequestMenu menu;
                AbstractContainerMenu patt0$temp = player.containerMenu;
                return patt0$temp instanceof RequestMenu && (menu = (RequestMenu)patt0$temp).getNetworkPos().equals((Object)this.getPos());
            });
            if (!playerList.isEmpty()) {
                ClientBoundItemListPayload toSend = this.requestItemList(this.pos);
                for (ServerPlayer player2 : playerList) {
                    Services.LOADER_SERVICE.sendToClient(player2, toSend);
                }
            }
            for (Object stockingPipe : this.stockingPipes) {
                if (!stockingPipe.isActiveStocking()) continue;
                stockingPipe.tryRequests(level);
            }
            this.cacheChanged = false;
            this.cacheCooldown = (byte)40;
        } else if (this.cacheCooldown > 0) {
            this.cacheCooldown = (byte)(this.cacheCooldown - 1);
        }
        this.getRequestedItems().removeIf(requestedItem -> {
            if (requestedItem.timedOut()) {
                requestedItem.sendMessage(level, (Component)Component.translatable((String)"chat.classicpipes.timed_out", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().getItem().getDescription()}).withStyle(ChatFormatting.RED));
                for (RecipePipeEntity craftingPipe : this.recipePipes) {
                    if (!requestedItem.matches(craftingPipe.getResult())) continue;
                    craftingPipe.dropHeldItems(level, craftingPipe.getBlockPos());
                }
                return true;
            }
            return false;
        });
    }

    public void resetRequests(ServerLevel level) {
        this.requestedItems.clear();
        for (RecipePipeEntity craftingPipe : this.recipePipes) {
            craftingPipe.dropHeldItems(level, craftingPipe.getBlockPos());
        }
    }

    public Set<RoutingPipeEntity> getRoutingPipes() {
        return this.routingPipes;
    }

    public Set<NetworkedPipeEntity> getDefaultRoutes() {
        return this.defaultRoutes;
    }

    public Set<StockingPipeEntity> getStockingPipes() {
        return this.stockingPipes;
    }

    public Set<MatchingPipe> getMatchingPipes() {
        return this.matchingPipes;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public void addPipe(NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.add(pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.add(routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.add(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.add(stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.add(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.add(recipePipe);
        }
    }

    public void removePipe(ServerLevel level, NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.remove((Object)pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.remove((Object)routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.remove(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.remove((Object)stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.remove(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.remove((Object)recipePipe);
        }
        this.requestedItems.removeIf(requestedItem -> {
            if (requestedItem.getDestination().equals((Object)pipe.getBlockPos())) {
                requestedItem.sendMessage(level, (Component)Component.translatable((String)"chat.classicpipes.destination_removed", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().getItem().getDescription(), pipe.getBlockPos().toShortString()}).withStyle(ChatFormatting.RED));
                return true;
            }
            return false;
        });
    }

    public ClientBoundItemListPayload requestItemList(BlockPos requestPos) {
        ArrayList<ItemStack> existingItems = new ArrayList<ItemStack>();
        for (ProviderPipe providerPipe : this.providerPipes) {
            for (ItemStack stack : providerPipe.getCache()) {
                boolean alreadyThere = false;
                for (ItemStack inStack : existingItems) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)inStack)) continue;
                    inStack.grow(stack.getCount());
                    if (inStack.getCount() < 0) {
                        inStack.setCount(Integer.MAX_VALUE);
                    }
                    alreadyThere = true;
                    break;
                }
                if (alreadyThere) continue;
                existingItems.add(stack.copy());
            }
        }
        ArrayList<ItemStack> craftableItems = new ArrayList<ItemStack>();
        for (RecipePipeEntity recipePipe : this.recipePipes) {
            ItemStack result = recipePipe.getResult();
            if (result.isEmpty()) continue;
            boolean matched = false;
            for (ItemStack alreadyCraftable : craftableItems) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)alreadyCraftable, (ItemStack)result)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            craftableItems.add(result.copyWithCount(1));
        }
        return new ClientBoundItemListPayload(existingItems, craftableItems, this.sortingMode, this.pos, requestPos);
    }

    public void cacheUpdated() {
        this.cacheChanged = true;
    }

    public void setSortingMode(SortingMode sortingMode) {
        this.sortingMode = sortingMode;
    }

    public SortingMode getSortingMode() {
        return this.sortingMode;
    }

    public List<RequestedItem> getRequestedItems() {
        return this.requestedItems;
    }

    public void removeRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.remove(requestedItem);
    }

    public void addRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.add(requestedItem);
    }
}

