/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.room.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;

public abstract class ProtectedWallBlock
extends Block {
    protected ProtectedWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!this.canPlayerBreak(player)) {
            return false;
        }
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        return level.setBlock(pos, fluid.createLegacyBlock(), level.isClientSide ? 11 : 3);
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter world, BlockPos pos, Player player) {
        return false;
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return false;
    }

    public boolean canPlayerBreak(Player player) {
        if (!player.isCreative()) {
            return false;
        }
        return player.isShiftKeyDown();
    }
}

