/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.EntityCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;

public class RemoveEntitiesCommand {
    private static final SuggestionProvider<CommandSourceStack> sugg = (ctx, builder) -> SharedSuggestionProvider.suggestResource((Iterable)BuiltInRegistries.ENTITY_TYPE.keySet(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> boolsugg = (ctx, builder) -> SharedSuggestionProvider.suggest(Collections.singletonList("force"), (SuggestionsBuilder)builder);
    private static int counter = 0;

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"remove").executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSourceStack>)ctx, null))).then(Commands.literal((String)"byType").then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests(sugg).executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"type")))).then(Commands.argument((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"type"))))))).then(((RequiredArgumentBuilder)Commands.argument((String)"type", (ArgumentType)ResourceLocationArgument.id()).suggests(sugg).executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"type")))).then(Commands.argument((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeEntities((CommandContext<CommandSourceStack>)ctx, ResourceLocationArgument.getId((CommandContext)ctx, (String)"type")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"items").executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSourceStack>)ctx, null))).then(Commands.argument((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSourceStack>)ctx, null)))).then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))).then(Commands.argument((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeItems((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"hostile").executes(RemoveEntitiesCommand::removeMonsters)).then(Commands.argument((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(RemoveEntitiesCommand::removeMonsters)))).then(Commands.literal((String)"regex").then(((RequiredArgumentBuilder)Commands.argument((String)"regex", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> RemoveEntitiesCommand.removeEntitiesByRegEx((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"regex")))).then(Commands.argument((String)"force", (ArgumentType)StringArgumentType.word()).suggests(boolsugg).executes(ctx -> RemoveEntitiesCommand.removeEntitiesByRegEx((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"regex"))))));
    }

    private static int removeEntities(CommandContext<CommandSourceStack> context, ResourceLocation type) {
        counter = 0;
        List<ServerLevel> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.getEntities().getAll().forEach(entity -> {
            if (type == null) {
                if (!entity.hasCustomName()) {
                    RemoveEntitiesCommand.removeEntity(entity);
                }
            } else {
                ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
                if (resourceLocation != null && resourceLocation.equals((Object)type)) {
                    RemoveEntitiesCommand.removeEntity(entity);
                }
            }
        }));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static int removeEntitiesByRegEx(CommandContext<CommandSourceStack> context, String regex) {
        counter = 0;
        List<ServerLevel> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.getEntities().getAll().forEach(entity -> {
            boolean remove = false;
            if (regex == null) {
                remove = !entity.hasCustomName();
            } else {
                ResourceLocation resourceLocation = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
                if (resourceLocation != null) {
                    remove = resourceLocation.toString().matches(regex);
                }
            }
            if (remove) {
                RemoveEntitiesCommand.removeEntity(entity);
            }
        }));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static int removeItems(CommandContext<CommandSourceStack> context, String type) {
        counter = 0;
        List<ServerLevel> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.getEntities().getAll().forEach(entity -> {
            if (entity instanceof ItemEntity) {
                if (type == null) {
                    RemoveEntitiesCommand.removeEntity(entity);
                } else if (entity.getName().getString().contains(type)) {
                    RemoveEntitiesCommand.removeEntity(entity);
                }
            }
        }));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static int removeMonsters(CommandContext<CommandSourceStack> context) {
        counter = 0;
        List<ServerLevel> worlds = WorldUtils.getWorldsFromDimensionArgument(context);
        worlds.forEach(world -> world.getEntities().getAll().forEach(entity -> {
            if (entity.getType().getCategory() == MobCategory.MONSTER && !entity.hasCustomName()) {
                RemoveEntitiesCommand.removeEntity(entity);
            }
        }));
        RemoveEntitiesCommand.respond(context);
        return 1;
    }

    private static void removeEntity(Entity e) {
        e.remove(Entity.RemovalReason.DISCARDED);
        ++counter;
    }

    private static void respond(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent("Removed " + counter + " Entities"), true);
    }
}

