/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.fluids.drain;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.drain.ItemDrainBlockEntity;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;

public class ItemDrainBlock
extends Block
implements IWrenchable,
IBE<ItemDrainBlockEntity> {
    public ItemDrainBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof BlockItem && stack.getCapability(Capabilities.FluidHandler.ITEM) == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return this.onBlockEntityUseItemOn((BlockGetter)level, pos, be -> {
            if (!stack.isEmpty()) {
                be.internalTank.allowInsertion();
                ItemInteractionResult tryExchange = this.tryExchange(level, player, hand, stack, (ItemDrainBlockEntity)be);
                be.internalTank.forbidInsertion();
                if (tryExchange.consumesAction()) {
                    return tryExchange;
                }
            }
            ItemStack heldItemStack = be.getHeldItemStack();
            if (!level.isClientSide && !heldItemStack.isEmpty()) {
                player.getInventory().placeItemBackInInventory(heldItemStack);
                be.heldItem = null;
                be.notifyUpdate();
            }
            return ItemInteractionResult.SUCCESS;
        });
    }

    public void updateEntityAfterFallOn(BlockGetter worldIn, Entity entityIn) {
        super.updateEntityAfterFallOn(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        if (!entityIn.isAlive()) {
            return;
        }
        if (entityIn.level().isClientSide) {
            return;
        }
        DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get(worldIn, entityIn.blockPosition(), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        Vec3 deltaMovement = entityIn.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
        Direction nearest = Direction.getNearest((double)deltaMovement.x, (double)deltaMovement.y, (double)deltaMovement.z);
        ItemStack remainder = inputBehaviour.handleInsertion(itemEntity.getItem(), nearest, false);
        itemEntity.setItem(remainder);
        if (remainder.isEmpty()) {
            itemEntity.discard();
        }
    }

    protected ItemInteractionResult tryExchange(Level worldIn, Player player, InteractionHand handIn, ItemStack heldItem, ItemDrainBlockEntity be) {
        if (FluidHelper.tryEmptyItemIntoBE(worldIn, player, handIn, heldItem, be)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (GenericItemEmptying.canItemBeEmptied(worldIn, heldItem)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.CASING_13PX.get(Direction.UP);
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.hasBlockEntity() || state.getBlock() == newState.getBlock()) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            ItemStack heldItemStack = be.getHeldItemStack();
            if (!heldItemStack.isEmpty()) {
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)heldItemStack);
            }
        });
        worldIn.removeBlockEntity(pos);
    }

    @Override
    public Class<ItemDrainBlockEntity> getBlockEntityClass() {
        return ItemDrainBlockEntity.class;
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    @Override
    public BlockEntityType<? extends ItemDrainBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.ITEM_DRAIN.get();
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level worldIn, BlockPos pos) {
        return ComparatorUtil.levelOfSmartFluidTank((BlockGetter)worldIn, pos);
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

